"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchNotesBySaveObjectIds = exports.fetchNotesByDocumentIds = exports.fetchNotes = exports.deleteNotes = exports.createNote = void 0;
var _kibana = require("../../common/lib/kibana");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Adds a new note.
 * This code is very close to the persistNote found in x-pack/solutions/security/plugins/security_solution/public/timelines/containers/notes/api.ts.
 * // TODO remove the old method when the transition to the new notes system is complete
 */
const createNote = async ({
  note
}) => {
  try {
    const response = await _kibana.KibanaServices.get().http.patch(_constants.NOTE_URL, {
      method: 'PATCH',
      body: JSON.stringify({
        note
      }),
      version: '2023-10-31'
    });
    const noteResponse = response.data.persistNote;
    if (noteResponse.code !== 200) {
      throw new Error(noteResponse.message);
    }
    return noteResponse.note;
  } catch (err) {
    var _err$body;
    // NOTE: this statement covers the case where the error originates on the backend side
    // and has a specific, custom message in the body that should be returned to the ui.
    if (err !== null && err !== void 0 && (_err$body = err.body) !== null && _err$body !== void 0 && _err$body.message) {
      throw new Error(err.body.message);
    }
    throw new Error('message' in err && err.message || 'Request failed');
  }
};
exports.createNote = createNote;
const fetchNotes = async ({
  page,
  perPage,
  sortField,
  sortOrder,
  filter,
  createdByFilter,
  associatedFilter,
  search
}) => {
  const response = await _kibana.KibanaServices.get().http.get(_constants.NOTE_URL, {
    query: {
      page,
      perPage,
      sortField,
      sortOrder,
      filter,
      createdByFilter,
      associatedFilter,
      search
    },
    version: '2023-10-31'
  });
  return response;
};

/**
 * Fetches all the notes for an array of document ids
 */
exports.fetchNotes = fetchNotes;
const fetchNotesByDocumentIds = async documentIds => {
  const response = await _kibana.KibanaServices.get().http.get(_constants.NOTE_URL, {
    query: {
      documentIds
    },
    version: '2023-10-31'
  });
  return response;
};

/**
 * Fetches all the notes for an array of saved object ids
 */
exports.fetchNotesByDocumentIds = fetchNotesByDocumentIds;
const fetchNotesBySaveObjectIds = async savedObjectIds => {
  const response = await _kibana.KibanaServices.get().http.get(_constants.NOTE_URL, {
    query: {
      savedObjectIds
    },
    version: '2023-10-31'
  });
  return response;
};

/**
 * Deletes multiple notes
 */
exports.fetchNotesBySaveObjectIds = fetchNotesBySaveObjectIds;
const deleteNotes = async noteIds => {
  const response = await _kibana.KibanaServices.get().http.delete(_constants.NOTE_URL, {
    body: JSON.stringify({
      noteIds
    }),
    version: '2023-10-31'
  });
  return response;
};
exports.deleteNotes = deleteNotes;