"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockManagementState = exports.managementReducer = void 0;
var _redux = require("redux");
var _policy_details = require("../pages/policy/store/policy_details");
var _constants = require("../common/constants");
var _reducer = require("../pages/endpoint_hosts/store/reducer");
var _builders = require("../pages/endpoint_hosts/store/builders");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const immutableCombineReducers = _redux.combineReducers;

/**
 * Returns the initial state of the store for the SIEM Management section
 */
const mockManagementState = exports.mockManagementState = {
  [_constants.MANAGEMENT_STORE_POLICY_DETAILS_NAMESPACE]: (0, _policy_details.initialPolicyDetailsState)(),
  [_constants.MANAGEMENT_STORE_ENDPOINTS_NAMESPACE]: (0, _builders.initialEndpointPageState)()
};

/**
 * Redux store reducer for the SIEM Management section
 */
const managementReducer = exports.managementReducer = immutableCombineReducers({
  [_constants.MANAGEMENT_STORE_POLICY_DETAILS_NAMESPACE]: _policy_details.policyDetailsReducer,
  [_constants.MANAGEMENT_STORE_ENDPOINTS_NAMESPACE]: _reducer.endpointListReducer
});