"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionsListPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _translations = require("../../../../app/translations");
var _administration_list_page = require("../../../components/administration_list_page");
var _response_actions_log = require("../../../components/endpoint_response_actions_list/response_actions_log");
var _translations2 = require("../../../components/endpoint_response_actions_list/translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResponseActionsListPage = () => {
  const [hideHeader, setHideHeader] = (0, _react.useState)(true);
  const resetPageHeader = (0, _react.useCallback)(isData => {
    setHideHeader(!isData);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_administration_list_page.AdministrationListPage, {
    "data-test-subj": "responseActionsPage",
    title: _translations.RESPONSE_ACTIONS_HISTORY,
    subtitle: _translations2.UX_MESSAGES.pageSubTitle,
    hideHeader: hideHeader
  }, /*#__PURE__*/_react.default.createElement(_response_actions_log.ResponseActionsLog, {
    showHostNames: true,
    isFlyout: false,
    setIsDataInResponse: resetPageHeader
  }));
};
exports.ResponseActionsListPage = ResponseActionsListPage;
ResponseActionsListPage.displayName = 'ResponseActionsListPage';