"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetProtectionUpdatesNote = exports.getProtectionUpdatesNoteQueryKey = void 0;
var _reactQuery = require("@tanstack/react-query");
var _resolve_path_variables = require("../../../../../../common/utils/resolve_path_variables");
var _constants = require("../../../../../../../common/endpoint/constants");
var _kibana = require("../../../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getProtectionUpdatesNoteQueryKey = packagePolicyId => `protection-updates-note-${packagePolicyId}`;
exports.getProtectionUpdatesNoteQueryKey = getProtectionUpdatesNoteQueryKey;
const useGetProtectionUpdatesNote = ({
  packagePolicyId
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)([getProtectionUpdatesNoteQueryKey(packagePolicyId)], () => http.get((0, _resolve_path_variables.resolvePathVariables)(_constants.PROTECTION_UPDATES_NOTE_ROUTE, {
    package_policy_id: packagePolicyId
  }), {
    version: '2023-10-31'
  }), {
    keepPreviousData: true,
    enabled: !!packagePolicyId,
    retry: false
  });
};
exports.useGetProtectionUpdatesNote = useGetProtectionUpdatesNote;