"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectPreventProtectionLevel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _setting_card = require("./setting_card");
var _types = require("../../../../../../../common/endpoint/types");
var _use_license = require("../../../../../../common/hooks/use_license");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DETECT_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.detect', {
  defaultMessage: 'Detect'
});
const PREVENT_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.prevent', {
  defaultMessage: 'Prevent'
});
const DetectPreventProtectionLevel = exports.DetectPreventProtectionLevel = /*#__PURE__*/(0, _react.memo)(({
  policy,
  protection,
  osList,
  mode,
  onChange,
  'data-test-subj': dataTestSubj
}) => {
  const isEditMode = mode === 'edit';
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const radios = (0, _react.useMemo)(() => {
    return [{
      id: _types.ProtectionModes.detect,
      label: DETECT_LABEL,
      flexGrow: 1
    }, {
      id: _types.ProtectionModes.prevent,
      label: PREVENT_LABEL,
      flexGrow: 5
    }];
  }, []);
  const currentProtectionLevelLabel = (0, _react.useMemo)(() => {
    const radio = radios.find(item => item.id === policy.windows[protection].mode);
    if (radio) {
      return radio.label;
    }
    return PREVENT_LABEL;
  }, [policy.windows, protection, radios]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId()
  }, /*#__PURE__*/_react.default.createElement(_setting_card.SettingCardHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyDetailsConfig.protectionLevel",
    defaultMessage: "Protection level"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, isEditMode ? radios.map(({
    label,
    id,
    flexGrow
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: flexGrow,
      key: id
    }, /*#__PURE__*/_react.default.createElement(ProtectionRadio, {
      policy: policy,
      onChange: onChange,
      mode: mode,
      protection: protection,
      protectionMode: id,
      osList: osList,
      label: label,
      "data-test-subj": getTestId(`${id}Radio`)
    }));
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, currentProtectionLevelLabel)));
});
DetectPreventProtectionLevel.displayName = 'DetectPreventProtectionLevel';
const ProtectionRadio = /*#__PURE__*/_react.default.memo(({
  protection,
  protectionMode,
  osList,
  label,
  onChange,
  policy,
  mode,
  'data-test-subj': dataTestSubj
}) => {
  const selected = policy.windows[protection].mode;
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const showEditableFormFields = mode === 'edit';
  const radioId = (0, _react.useMemo)(() => {
    return `${osList.join('-')}-${protection}-${protectionMode}`;
  }, [osList, protection, protectionMode]);
  const handleRadioChange = (0, _react.useCallback)(() => {
    const newPayload = (0, _lodash.cloneDeep)(policy);
    for (const os of osList) {
      if (os === 'windows') {
        newPayload[os][protection].mode = protectionMode;
      } else if (os === 'mac') {
        newPayload[os][protection].mode = protectionMode;
      } else if (os === 'linux') {
        newPayload[os][protection].mode = protectionMode;
      }
      if (isPlatinumPlus) {
        if (os === 'windows') {
          if (protectionMode === _types.ProtectionModes.prevent) {
            newPayload[os].popup[protection].enabled = true;
          } else {
            newPayload[os].popup[protection].enabled = false;
          }
        } else if (os === 'mac') {
          if (protectionMode === _types.ProtectionModes.prevent) {
            newPayload[os].popup[protection].enabled = true;
          } else {
            newPayload[os].popup[protection].enabled = false;
          }
        } else if (os === 'linux') {
          if (protectionMode === _types.ProtectionModes.prevent) {
            newPayload[os].popup[protection].enabled = true;
          } else {
            newPayload[os].popup[protection].enabled = false;
          }
        }
      }
    }
    onChange({
      isValid: true,
      updatedPolicy: newPayload
    });
  }, [isPlatinumPlus, onChange, osList, policy, protection, protectionMode]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    label: label,
    id: radioId,
    checked: selected === protectionMode,
    onChange: handleRadioChange,
    disabled: !showEditableFormFields || selected === _types.ProtectionModes.off,
    "data-test-subj": dataTestSubj
  });
});
ProtectionRadio.displayName = 'ProtectionRadio';