"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReputationService = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _kibana = require("../../../../../../../../../common/lib/kibana");
var _use_test_id_generator = require("../../../../../../../../hooks/use_test_id_generator");
var _setting_card = require("../../../setting_card");
var _types = require("../../../../../../../../../../common/endpoint/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReputationService = exports.ReputationService = /*#__PURE__*/_react.default.memo(({
  policy,
  onChange,
  mode,
  protection,
  'data-test-subj': dataTestSubj
}) => {
  var _cloud$isCloudEnabled;
  const isEditMode = mode === 'edit';
  const {
    cloud
  } = (0, _kibana.useKibana)().services;
  const isCloud = (_cloud$isCloudEnabled = cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled) !== null && _cloud$isCloudEnabled !== void 0 ? _cloud$isCloudEnabled : false;
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const protectionTurnedOn = policy.windows.behavior_protection.mode !== _types.ProtectionModes.off;
  const checkboxChecked = policy.windows.behavior_protection.reputation_service && protectionTurnedOn;
  const handleChange = (0, _react.useCallback)(event => {
    const newPayload = (0, _lodash.cloneDeep)(policy);
    newPayload.windows.behavior_protection.reputation_service = event.target.checked;
    newPayload.mac.behavior_protection.reputation_service = event.target.checked;
    newPayload.linux.behavior_protection.reputation_service = event.target.checked;
    onChange({
      isValid: true,
      updatedPolicy: newPayload
    });
  }, [policy, onChange]);
  if (!isCloud) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_setting_card.SettingCardHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": getTestId('label')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyDetailsConfig.reputationService",
    defaultMessage: "Reputation service"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": getTestId('tooltipIcon')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "right",
    "data-test-subj": getTestId('tooltip'),
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.policyDetailsConfig.reputationServiceTooltip",
      defaultMessage: "This option enables/disables the Reputation Service feature in Endpoint. When the option is ON, Endpoint will reach out to a Cloud API for additional detection coverage. When it's OFF, Endpoint will not reach out to the Cloud API, resulting in reduced efficacy."
    })
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": getTestId('checkbox'),
    id: `${protection}ReputationServiceCheckbox}`,
    onChange: handleChange,
    checked: checkboxChecked,
    disabled: !protectionTurnedOn || !isEditMode,
    label: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetail.reputationService', {
      defaultMessage: 'Reputation service'
    })
  }));
});
ReputationService.displayName = 'ReputationService';