"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventFiltersApiClient = void 0;
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _constants = require("../../../../../common/endpoint/constants");
var _resolve_path_variables = require("../../../../common/utils/resolve_path_variables");
var _exceptions_list_api_client = require("../../../services/exceptions_list/exceptions_list_api_client");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function writeTransform(item) {
  return (0, _securitysolutionListHooks.removeIdFromExceptionItemsEntries)(item);
}

/**
 * Event filters Api client class using ExceptionsListApiClient as base class
 * It follow the Singleton pattern.
 * Please, use the getInstance method instead of creating a new instance when using this implementation.
 */
class EventFiltersApiClient extends _exceptions_list_api_client.ExceptionsListApiClient {
  constructor(http) {
    super(http, _securitysolutionListConstants.ENDPOINT_ARTIFACT_LISTS.eventFilters.id, _constants2.EVENT_FILTER_LIST_DEFINITION, undefined, writeTransform);
  }
  static getInstance(http) {
    return super.getInstance(http, _securitysolutionListConstants.ENDPOINT_ARTIFACT_LISTS.eventFilters.id, _constants2.EVENT_FILTER_LIST_DEFINITION, undefined, writeTransform);
  }

  /**
   * Returns suggestions for given field
   */
  async getSuggestions(body) {
    const result = await this.getHttp().post((0, _resolve_path_variables.resolvePathVariables)(_constants.SUGGESTIONS_INTERNAL_ROUTE, {
      suggestion_type: 'eventFilters'
    }), {
      version: '1',
      body: JSON.stringify(body)
    });
    return result;
  }
}
exports.EventFiltersApiClient = EventFiltersApiClient;