"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowInsightsScanSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _fp = require("lodash/fp");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _lodash = require("lodash");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _user_privileges = require("../../../../../../../common/components/user_privileges");
var _use_space_id = require("../../../../../../../common/hooks/use_space_id");
var _translations = require("../../../translations");
var _kibana = require("../../../../../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkflowInsightsScanSection = ({
  isScanButtonDisabled,
  onScanButtonClick
}) => {
  var _useSpaceId;
  const CONNECTOR_ID_LOCAL_STORAGE_KEY = 'connectorId';
  const spaceId = (_useSpaceId = (0, _use_space_id.useSpaceId)()) !== null && _useSpaceId !== void 0 ? _useSpaceId : 'default';
  const {
    http,
    settings
  } = (0, _kibana.useKibana)().services;
  const {
    data: aiConnectors
  } = (0, _elasticAssistant.useLoadConnectors)({
    http,
    settings
  });
  const {
    canWriteWorkflowInsights
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;

  // Store the selected connector id in local storage so that it persists across page reloads
  const [localStorageWorkflowInsightsConnectorId, setLocalStorageWorkflowInsightsConnectorId] = (0, _useLocalStorage.default)(`${_elasticAssistant.DEFAULT_ASSISTANT_NAMESPACE}.${_elasticAssistant.DEFEND_INSIGHTS_STORAGE_KEY}.${spaceId}.${CONNECTOR_ID_LOCAL_STORAGE_KEY}`);
  const [connectorId, setConnectorId] = _react.default.useState(localStorageWorkflowInsightsConnectorId);
  const onConnectorIdSelected = (0, _react.useCallback)(selectedConnectorId => {
    setConnectorId(selectedConnectorId);
    setLocalStorageWorkflowInsightsConnectorId(selectedConnectorId);
  }, [setLocalStorageWorkflowInsightsConnectorId]);

  // Check if the selected connector exists in the list of connectors, i.e. it is not deleted
  const connectorExists = (0, _react.useMemo)(() => (0, _lodash.some)(aiConnectors, ['id', connectorId]), [aiConnectors, connectorId]);
  const selectedConnectorActionTypeId = (0, _react.useMemo)(() => {
    const selectedConnector = aiConnectors === null || aiConnectors === void 0 ? void 0 : aiConnectors.find(connector => connector.id === connectorId);
    return selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.actionTypeId;
  }, [aiConnectors, connectorId]);

  // Render the scan button only if a connector is selected
  const scanButton = (0, _react.useMemo)(() => {
    if (!connectorExists) {
      return null;
    }
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      isLoading: isScanButtonDisabled,
      isDisabled: !canWriteWorkflowInsights,
      onClick: () => {
        if (!connectorId || !selectedConnectorActionTypeId) return;
        onScanButtonClick({
          connectorId,
          actionTypeId: selectedConnectorActionTypeId
        });
      }
    }, isScanButtonDisabled ? _translations.WORKFLOW_INSIGHTS.scan.loading : _translations.WORKFLOW_INSIGHTS.scan.button));
    if (!canWriteWorkflowInsights) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _translations.WORKFLOW_INSIGHTS.scan.noPermissions,
        position: 'top'
      }, button);
    }
    return button;
  }, [canWriteWorkflowInsights, connectorExists, connectorId, isScanButtonDisabled, onScanButtonClick, selectedConnectorActionTypeId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantIcon, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _translations.WORKFLOW_INSIGHTS.scan.title))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.ConnectorSelectorInline, {
    onConnectorSelected: _fp.noop,
    onConnectorIdSelected: onConnectorIdSelected,
    selectedConnectorId: connectorId
  })), scanButton))));
};
exports.WorkflowInsightsScanSection = WorkflowInsightsScanSection;