"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetAgentStatus = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../common/constants");
var _constants2 = require("../../../../common/endpoint/constants");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieve the status of a supported host's agent type
 * @param agentIds
 * @param agentType
 * @param options
 */
const useGetAgentStatus = (agentIds, agentType, options = {}) => {
  const http = (0, _kibana.useHttp)();
  const agentIdList = (Array.isArray(agentIds) ? agentIds : [agentIds]).filter(agentId => agentId.trim().length);
  return (0, _reactQuery.useQuery)({
    queryKey: ['get-agent-status', agentIdList],
    refetchInterval: _constants.DEFAULT_POLL_INTERVAL,
    ...options,
    queryFn: () => {
      if (agentIdList.length === 0) {
        return {};
      }
      return http.get(_constants2.AGENT_STATUS_ROUTE, {
        version: '1',
        query: {
          agentIds: agentIdList,
          agentType
        }
      }).then(response => response.data);
    }
  });
};
exports.useGetAgentStatus = useGetAgentStatus;