"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyResponseArtifactItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledArtifactName = (0, _styledComponents.default)(_eui.EuiText)`
  white-space: nowrap;
  line-height: inherit;
  overflow: hidden;
  text-overflow: ellipsis;
`;
const StyledShaValue = (0, _styledComponents.default)(_eui.EuiText)`
  width: 80px;
  white-space: nowrap;
  line-height: inherit;
  overflow: hidden;
  text-overflow: ellipsis;
`;
const IconContainer = (0, _styledComponents.default)(_eui.EuiText)`
  padding: 2px;
  border: ${({
  theme
}) => theme.eui.euiBorderThin};
  border-radius: ${({
  theme
}) => theme.eui.euiBorderRadiusSmall};
`;
const COPY_TOOLTIP = {
  BEFORE: _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.artifact.copyButton.beforeCopyTooltip', {
    defaultMessage: 'Copy artifact ID'
  }),
  AFTER: _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.artifact.copyButton.afterCopyTooltip', {
    defaultMessage: 'Artifact ID copied!'
  })
};
const PolicyResponseArtifactItem = exports.PolicyResponseArtifactItem = /*#__PURE__*/(0, _react.memo)(({
  artifact
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "spaceBetween",
    style: {
      flexWrap: 'nowrap'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    style: {
      alignItems: 'flex-start'
    },
    className: 'eui-textTruncate'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: artifact.name,
    anchorClassName: 'eui-textTruncate'
  }, /*#__PURE__*/_react.default.createElement(StyledArtifactName, {
    "data-test-subj": "endpointPolicyResponseArtifactName"
  }, artifact.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "s",
    style: {
      flexWrap: 'nowrap'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(IconContainer, {
    size: 'xs'
  }, 'sha256')), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(StyledShaValue, {
    "data-test-subj": "endpointPolicyResponseArtifactSha256"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: artifact.sha256
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _lodash.truncate)(artifact.sha256, {
    length: 12
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      marginTop: '-4px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: artifact.sha256,
    beforeMessage: COPY_TOOLTIP.BEFORE,
    afterMessage: COPY_TOOLTIP.AFTER
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    color: "primary",
    type: "copyClipboard",
    onClick: copy,
    "data-test-subj": "endpointPolicyResponseArtifactCopyButton"
  }))))));
});
PolicyResponseArtifactItem.displayName = 'PolicyResponseArtifactItem';