"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PoliciesSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GLOBAL_ENTRIES = _i18n.i18n.translate('xpack.securitySolution.management.policiesSelector.globalEntries', {
  defaultMessage: 'Global entries'
});
const UNASSIGNED_ENTRIES = _i18n.i18n.translate('xpack.securitySolution.management.policiesSelector.unassignedEntries', {
  defaultMessage: 'Unassigned entries'
});
const PoliciesSelector = exports.PoliciesSelector = /*#__PURE__*/(0, _react.memo)(({
  policies,
  onChangeSelection,
  defaultExcludedPolicies,
  defaultIncludedPolicies
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [query, setQuery] = (0, _react.useState)('');
  const [itemsList, setItemsList] = (0, _react.useState)([]);
  const isExcludePoliciesInFilterEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('excludePoliciesInFilterEnabled');
  (0, _react.useEffect)(() => {
    const defaultIncludedPoliciesByKey = defaultIncludedPolicies ? defaultIncludedPolicies.split(',').reduce((acc, val) => ({
      ...acc,
      [val]: true
    }), {}) : {};
    const defaultExcludedPoliciesByKey = defaultExcludedPolicies ? defaultExcludedPolicies.split(',').reduce((acc, val) => ({
      ...acc,
      [val]: true
    }), {}) : {};
    const getCheckedValue = id => defaultIncludedPoliciesByKey[id] ? 'on' : defaultExcludedPoliciesByKey[id] ? 'off' : undefined;
    setItemsList([...policies.map(policy => ({
      name: policy.name,
      id: policy.id,
      checked: getCheckedValue(policy.id)
    })), {
      name: GLOBAL_ENTRIES,
      id: 'global',
      checked: getCheckedValue('global')
    }, {
      name: UNASSIGNED_ENTRIES,
      id: 'unassigned',
      checked: getCheckedValue('unassigned')
    }]);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [policies]);
  const onButtonClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(prevIsPopoverOpen => !prevIsPopoverOpen);
  }, []);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const onChange = (0, _react.useCallback)(ev => {
    const value = ev.target.value || '';
    setQuery(value);
  }, []);
  const updateItem = (0, _react.useCallback)(index => {
    if (!itemsList[index]) {
      return;
    }
    const newItems = [...itemsList];
    switch (newItems[index].checked) {
      case 'on':
        newItems[index].checked = isExcludePoliciesInFilterEnabled ? 'off' : undefined;
        break;
      case 'off':
        newItems[index].checked = undefined;
        break;
      default:
        newItems[index].checked = 'on';
    }
    setItemsList(newItems);
    onChangeSelection(newItems);
  }, [itemsList, onChangeSelection, isExcludePoliciesInFilterEnabled]);
  const dropdownItems = (0, _react.useMemo)(() => itemsList.map((item, index) => item.name.toLowerCase().includes(query.toLowerCase()) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
    checked: item.checked,
    key: index,
    onClick: () => updateItem(index),
    "data-test-subj": `policiesSelector-popover-items-${item.id}`
  }, item.name) : null), [itemsList, query, updateItem]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    "data-test-subj": "policiesSelectorButton",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    numFilters: itemsList.length,
    hasActiveFilters: !!itemsList.find(item => item.checked === 'on'),
    numActiveFilters: itemsList.filter(item => item.checked === 'on').length
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.management.policiesSelector.label",
    defaultMessage: "Policies"
  }))), [isPopoverOpen, itemsList, onButtonClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "policiesSelector",
    direction: "row",
    alignItems: "center",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "policiesSelectorSearch",
    compressed: true,
    onChange: onChange,
    value: query
  })), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "policiesSelector-popover",
    className: "eui-yScroll",
    css: {
      maxHeight: euiTheme.base * 30
    }
  }, dropdownItems)))));
});
PoliciesSelector.displayName = 'PoliciesSelector';