"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCustomScriptsErrorToast = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Shows a danger toast with details if scriptsError is present.
 * @param scriptsError Error object from custom scripts fetch
 * @param notifications Kibana notifications service
 */
const useCustomScriptsErrorToast = (scriptsError, notifications) => {
  (0, _react.useEffect)(() => {
    if (scriptsError) {
      var _err$body;
      let code = 'Error';
      let message;
      const err = scriptsError;
      if (err !== null && err !== void 0 && (_err$body = err.body) !== null && _err$body !== void 0 && _err$body.message) {
        var _err$body$statusCode;
        message = err.body.message;
        code = String((_err$body$statusCode = err.body.statusCode) !== null && _err$body$statusCode !== void 0 ? _err$body$statusCode : code);
      } else {
        message = (err === null || err === void 0 ? void 0 : err.message) || String(err);
      }
      if (message) {
        notifications.toasts.addDanger({
          title: `Error: ${code}`,
          text: message
        });
      }
    }
  }, [scriptsError, notifications]);
};
exports.useCustomScriptsErrorToast = useCustomScriptsErrorToast;