"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelpCommandArgument = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _command_usage = require("../command_usage");
var _help_output = require("../help_output");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Builtin component that handles the output of command's `--help` argument
 */
const HelpCommandArgument = exports.HelpCommandArgument = /*#__PURE__*/(0, _react.memo)(props => {
  const CustomCommandHelp = props.command.commandDefinition.HelpComponent;
  (0, _react.useEffect)(() => {
    if (!CustomCommandHelp) {
      props.setStatus('success');
    }
  }, [CustomCommandHelp, props]);
  return CustomCommandHelp ? /*#__PURE__*/_react.default.createElement(CustomCommandHelp, props) : /*#__PURE__*/_react.default.createElement(_help_output.HelpOutput, {
    command: props.command,
    title: _i18n.i18n.translate('xpack.securitySolution.console.buildInCommand.helpArgument.helpTitle', {
      defaultMessage: '{cmdName} command',
      values: {
        cmdName: props.command.args.name
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_command_usage.CommandUsage, {
    commandDef: props.command.commandDefinition,
    errorMessage: props.store.errorMessage
  }));
});
HelpCommandArgument.displayName = 'HelpCommandArgument';