"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDefaultOrMissing = exports.extractPageSizeNumber = exports.extractPageNumber = exports.extractFirstParamValue = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-nodejs-modules

/**
 * Checks if a given value is either undefined or equal to the default value provided on input
 * @param value
 * @param defaultValue
 */
const isDefaultOrMissing = (value, defaultValue) => {
  return value === undefined || value === defaultValue || value === 0;
};

/**
 * Given an object with url params, and a given key, return back only the first param value (case multiples were defined)
 * @param query
 * @param key
 */
exports.isDefaultOrMissing = isDefaultOrMissing;
const extractFirstParamValue = (query, key) => {
  const value = query[key];
  return Array.isArray(value) ? value[value.length - 1] : value;
};

/**
 * Extracts the page number from a url query object `page` param and validates it.
 * @param query
 */
exports.extractFirstParamValue = extractFirstParamValue;
const extractPageNumber = query => {
  const pageIndex = Number(extractFirstParamValue(query, 'page'));
  return !Number.isFinite(pageIndex) || pageIndex < 1 ? 1 : pageIndex;
};

/**
 * Extracts the page size from a url query object `pageSize` param and validates it
 * @param query
 */
exports.extractPageNumber = extractPageNumber;
const extractPageSizeNumber = query => {
  const pageSize = Number(extractFirstParamValue(query, 'pageSize'));
  return _constants.MANAGEMENT_PAGE_SIZE_OPTIONS.includes(pageSize) ? pageSize : _constants.MANAGEMENT_DEFAULT_PAGE_SIZE;
};
exports.extractPageSizeNumber = extractPageSizeNumber;