"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MANAGEMENT_STORE_POLICY_DETAILS_NAMESPACE = exports.MANAGEMENT_STORE_GLOBAL_NAMESPACE = exports.MANAGEMENT_STORE_ENDPOINTS_NAMESPACE = exports.MANAGEMENT_ROUTING_TRUSTED_APPS_PATH = exports.MANAGEMENT_ROUTING_RESPONSE_ACTIONS_HISTORY_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_TRUSTED_APPS_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_PROTECTION_UPDATES_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_PATH_OLD = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_HOST_ISOLATION_EXCEPTIONS_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_FORM_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_EVENT_FILTERS_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_BLOCKLISTS_PATH = exports.MANAGEMENT_ROUTING_POLICIES_PATH = exports.MANAGEMENT_ROUTING_NOTES_PATH = exports.MANAGEMENT_ROUTING_HOST_ISOLATION_EXCEPTIONS_PATH = exports.MANAGEMENT_ROUTING_EVENT_FILTERS_PATH = exports.MANAGEMENT_ROUTING_ENDPOINTS_PATH = exports.MANAGEMENT_ROUTING_BLOCKLIST_PATH = exports.MANAGEMENT_PAGE_SIZE_OPTIONS = exports.MANAGEMENT_DEFAULT_SORT_ORDER = exports.MANAGEMENT_DEFAULT_SORT_FIELD = exports.MANAGEMENT_DEFAULT_PAGE_SIZE = exports.MANAGEMENT_DEFAULT_PAGE = exports.DEFAULT_POLL_INTERVAL = void 0;
var _constants = require("../../../common/constants");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// --[ ROUTING ]---------------------------------------------------------------------------
const MANAGEMENT_ROUTING_ENDPOINTS_PATH = exports.MANAGEMENT_ROUTING_ENDPOINTS_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.endpoints})`;
const MANAGEMENT_ROUTING_POLICIES_PATH = exports.MANAGEMENT_ROUTING_POLICIES_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.policies})`;
const MANAGEMENT_ROUTING_POLICY_DETAILS_FORM_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_FORM_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.policies})/:policyId/settings`;
const MANAGEMENT_ROUTING_POLICY_DETAILS_TRUSTED_APPS_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_TRUSTED_APPS_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.policies})/:policyId/trustedApps`;
const MANAGEMENT_ROUTING_POLICY_DETAILS_EVENT_FILTERS_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_EVENT_FILTERS_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.policies})/:policyId/eventFilters`;
const MANAGEMENT_ROUTING_POLICY_DETAILS_HOST_ISOLATION_EXCEPTIONS_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_HOST_ISOLATION_EXCEPTIONS_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.policies})/:policyId/hostIsolationExceptions`;
const MANAGEMENT_ROUTING_POLICY_DETAILS_BLOCKLISTS_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_BLOCKLISTS_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.policies})/:policyId/blocklists`;
const MANAGEMENT_ROUTING_POLICY_DETAILS_PROTECTION_UPDATES_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_PROTECTION_UPDATES_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.policies})/:policyId/protectionUpdates`;
const MANAGEMENT_ROUTING_NOTES_PATH = exports.MANAGEMENT_ROUTING_NOTES_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.notes})`;
/** @deprecated use the paths defined above instead */
const MANAGEMENT_ROUTING_POLICY_DETAILS_PATH_OLD = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_PATH_OLD = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.policies})/:policyId`;
const MANAGEMENT_ROUTING_TRUSTED_APPS_PATH = exports.MANAGEMENT_ROUTING_TRUSTED_APPS_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.trustedApps})`;
const MANAGEMENT_ROUTING_EVENT_FILTERS_PATH = exports.MANAGEMENT_ROUTING_EVENT_FILTERS_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.eventFilters})`;
const MANAGEMENT_ROUTING_HOST_ISOLATION_EXCEPTIONS_PATH = exports.MANAGEMENT_ROUTING_HOST_ISOLATION_EXCEPTIONS_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.hostIsolationExceptions})`;
const MANAGEMENT_ROUTING_BLOCKLIST_PATH = exports.MANAGEMENT_ROUTING_BLOCKLIST_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.blocklist})`;
const MANAGEMENT_ROUTING_RESPONSE_ACTIONS_HISTORY_PATH = exports.MANAGEMENT_ROUTING_RESPONSE_ACTIONS_HISTORY_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.responseActionsHistory})`;

// --[ STORE ]---------------------------------------------------------------------------
/** The SIEM global store namespace where the management state will be mounted */
const MANAGEMENT_STORE_GLOBAL_NAMESPACE = exports.MANAGEMENT_STORE_GLOBAL_NAMESPACE = 'management';
/** Namespace within the Management state where policy details state is maintained */
const MANAGEMENT_STORE_POLICY_DETAILS_NAMESPACE = exports.MANAGEMENT_STORE_POLICY_DETAILS_NAMESPACE = 'policyDetails';
/** Namespace within the Management state where endpoint-host state is maintained */
const MANAGEMENT_STORE_ENDPOINTS_NAMESPACE = exports.MANAGEMENT_STORE_ENDPOINTS_NAMESPACE = 'endpoints';
const MANAGEMENT_PAGE_SIZE_OPTIONS = exports.MANAGEMENT_PAGE_SIZE_OPTIONS = [10, 20, 50];
const MANAGEMENT_DEFAULT_PAGE = exports.MANAGEMENT_DEFAULT_PAGE = 0;
const MANAGEMENT_DEFAULT_PAGE_SIZE = exports.MANAGEMENT_DEFAULT_PAGE_SIZE = 10;
const MANAGEMENT_DEFAULT_SORT_ORDER = exports.MANAGEMENT_DEFAULT_SORT_ORDER = 'desc';
const MANAGEMENT_DEFAULT_SORT_FIELD = exports.MANAGEMENT_DEFAULT_SORT_FIELD = 'created_at';

// --[ DEFAULTS ]---------------------------------------------------------------------------
/** The default polling interval for API calls that require a refresh interval */
const DEFAULT_POLL_INTERVAL = exports.DEFAULT_POLL_INTERVAL = 10000;