"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFetchData = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Reusable method that returns a promise wrapping the search functionality of Kibana search service
 */
const createFetchData = async (searchService, req) => {
  let rawResponse;
  return new Promise((resolve, reject) => {
    searchService.search(req).subscribe({
      next: response => {
        rawResponse = response.rawResponse;
      },
      complete: () => {
        resolve(rawResponse);
      },
      error: error => {
        reject(error);
      }
    });
  });
};
exports.createFetchData = createFetchData;