"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowRelatedAlertsBySession = void 0;
var _field_names = require("../constants/field_names");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns true if document has process.entry_leader.entity_id field with values
 */
const useShowRelatedAlertsBySession = ({
  getFieldsData
}) => {
  const entityId = (0, _utils.getField)(getFieldsData(_field_names.ENTRY_LEADER_ENTITY_ID));
  return {
    show: entityId != null,
    ...(entityId && {
      entityId
    })
  };
};
exports.useShowRelatedAlertsBySession = useShowRelatedAlertsBySession;