"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableFieldValueCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _get_field_format = require("../utils/get_field_format");
var _helpers = require("../../../../common/components/tables/helpers");
var _formatted_field = require("../../../../timelines/components/timeline/body/renderers/formatted_field");
var _constants = require("../../../../timelines/components/timeline/body/renderers/constants");
var _test_ids = require("./test_ids");
var _link_utils = require("../../../shared/utils/link_utils");
var _preview_link = require("../../../shared/components/preview_link");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Renders the value of a field in the second column of the table
 */
const TableFieldValueCell = exports.TableFieldValueCell = /*#__PURE__*/(0, _react.memo)(({
  scopeId,
  data,
  eventId,
  fieldFromBrowserField,
  ruleId,
  getLinkValue,
  values,
  isRulePreview
}) => {
  if (values == null) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `event-field-${data.field}`,
    direction: "column",
    gutterSize: "xs"
  }, values.map((value, i) => {
    if (fieldFromBrowserField == null) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: `${i}-${value}`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        key: `${i}-${value}`
      }, value));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: `${i}-${value}`
    }, data.field === _constants.MESSAGE_FIELD_NAME ? /*#__PURE__*/_react.default.createElement(_helpers.OverflowField, {
      value: value
    }) : (0, _link_utils.isFlyoutLink)({
      field: data.field,
      ruleId,
      scopeId
    }) ? /*#__PURE__*/_react.default.createElement(_preview_link.PreviewLink, {
      field: data.field,
      value: value,
      scopeId: scopeId,
      ruleId: ruleId,
      "data-test-subj": `${_test_ids.FLYOUT_TABLE_PREVIEW_LINK_FIELD_TEST_ID}-${i}`
    }) : /*#__PURE__*/_react.default.createElement(_formatted_field.FormattedFieldValue, {
      contextId: `${scopeId}-${eventId}-${data.field}-${i}-${value}`,
      eventId: eventId,
      fieldFormat: (0, _get_field_format.getFieldFormat)(data),
      fieldName: data.field,
      fieldFromBrowserField: fieldFromBrowserField,
      fieldType: data.type,
      isAggregatable: fieldFromBrowserField.aggregatable,
      isObjectArray: data.isObjectArray,
      value: value,
      linkValue: getLinkValue && getLinkValue(data.field),
      truncate: false
    }));
  }));
});
TableFieldValueCell.displayName = 'TableFieldValueCell';