"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScore = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Document details risk score displayed in flyout right section header
 */
const RiskScore = exports.RiskScore = /*#__PURE__*/(0, _react.memo)(({
  getFieldsData
}) => {
  const fieldsData = getFieldsData(_ruleDataUtils.ALERT_RISK_SCORE);
  if (!fieldsData) {
    return null;
  }
  let alertRiskScore;
  if (typeof fieldsData === 'string') {
    alertRiskScore = fieldsData;
  } else if (Array.isArray(fieldsData) && fieldsData.length > 0) {
    alertRiskScore = fieldsData[0];
  } else {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": _test_ids.RISK_SCORE_VALUE_TEST_ID
  }, alertRiskScore);
});
RiskScore.displayName = 'RiskScore';