"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationGuide = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_investigation_guide = require("../../shared/hooks/use_investigation_guide");
var _context = require("../../shared/context");
var _test_ids = require("./test_ids");
var _investigation_guide_view = require("./investigation_guide_view");
var _flyout_loading = require("../../../shared/components/flyout_loading");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Investigation guide displayed in the left panel.
 * Renders a message saying the guide hasn't been set up or the full investigation guide.
 */
const InvestigationGuide = () => {
  const {
    dataFormattedForFieldBrowser,
    isRulePreview
  } = (0, _context.useDocumentDetailsContext)();
  const {
    loading,
    error,
    basicAlertData,
    ruleNote
  } = (0, _use_investigation_guide.useInvestigationGuide)({
    dataFormattedForFieldBrowser
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.INVESTIGATION_GUIDE_TEST_ID
  }, isRulePreview ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.investigation.previewMessage",
    defaultMessage: "Investigation guide is not available in alert preview."
  }) : loading ? /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, {
    "data-test-subj": _test_ids.INVESTIGATION_GUIDE_LOADING_TEST_ID
  }) : !error && basicAlertData.ruleId && ruleNote ? /*#__PURE__*/_react.default.createElement(_investigation_guide_view.InvestigationGuideView, {
    basicData: basicAlertData,
    ruleNote: ruleNote,
    showTitle: false,
    showFullView: true
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.investigation.noDataDescription",
    defaultMessage: "There's no investigation guide for this rule. {documentation} to add one.",
    values: {
      documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/en/security/current/rules-ui-management.html#edit-rules-settings",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.left.investigation.noDataLinkText",
        defaultMessage: "Edit the rule's settings"
      }))
    }
  }));
};
exports.InvestigationGuide = InvestigationGuide;
InvestigationGuide.displayName = 'InvestigationGuide';