"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAIForSOCDetailsContext = exports.AIForSOCDetailsProvider = exports.AIForSOCDetailsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _use_rule_with_fallback = require("../../detection_engine/rule_management/logic/use_rule_with_fallback");
var _use_space_id = require("../../common/hooks/use_space_id");
var _flyout_loading = require("../shared/components/flyout_loading");
var _use_event_details = require("../document_details/shared/hooks/use_event_details");
var _flyout_error = require("../shared/components/flyout_error");
var _use_basic_data_from_details_data = require("../document_details/shared/hooks/use_basic_data_from_details_data");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A context provider for the AI for SOC alert summary flyout
 */
const AIForSOCDetailsContext = exports.AIForSOCDetailsContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const AIForSOCDetailsProvider = exports.AIForSOCDetailsProvider = /*#__PURE__*/(0, _react.memo)(({
  id,
  indexName,
  children
}) => {
  const {
    browserFields,
    dataAsNestedObject,
    dataFormattedForFieldBrowser,
    getFieldsData,
    loading,
    searchHit
  } = (0, _use_event_details.useEventDetails)({
    eventId: id,
    indexName
  });
  const {
    ruleId
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const {
    rule: maybeRule
  } = (0, _use_rule_with_fallback.useRuleWithFallback)(ruleId);
  const spaceId = (0, _use_space_id.useSpaceId)();
  const [showAnonymizedValues = spaceId ? false : undefined, setShowAnonymizedValues] = (0, _useLocalStorage.default)(`securitySolution.aiAlertFlyout.showAnonymization.${spaceId}`);
  const contextValue = (0, _react.useMemo)(() => {
    var _maybeRule$investigat, _maybeRule$investigat2;
    return dataFormattedForFieldBrowser && dataAsNestedObject && id && indexName && searchHit ? {
      browserFields,
      dataFormattedForFieldBrowser,
      dataAsNestedObject,
      eventId: id,
      getFieldsData,
      indexName,
      searchHit,
      investigationFields: (_maybeRule$investigat = maybeRule === null || maybeRule === void 0 ? void 0 : (_maybeRule$investigat2 = maybeRule.investigation_fields) === null || _maybeRule$investigat2 === void 0 ? void 0 : _maybeRule$investigat2.field_names) !== null && _maybeRule$investigat !== void 0 ? _maybeRule$investigat : [],
      setShowAnonymizedValues,
      showAnonymizedValues
    } : undefined;
  }, [browserFields, dataAsNestedObject, dataFormattedForFieldBrowser, getFieldsData, id, indexName, maybeRule, searchHit, setShowAnonymizedValues, showAnonymizedValues]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, null);
  }
  if (!contextValue) {
    return /*#__PURE__*/_react.default.createElement(_flyout_error.FlyoutError, null);
  }
  return /*#__PURE__*/_react.default.createElement(AIForSOCDetailsContext.Provider, {
    value: contextValue
  }, children);
});
AIForSOCDetailsProvider.displayName = 'AIForSOCDetailsProvider';
const useAIForSOCDetailsContext = () => {
  const contextValue = (0, _react.useContext)(AIForSOCDetailsContext);
  if (!contextValue) {
    throw new Error('AIForSOCDetailsContext can only be used within AIForSOCDetailsContext provider');
  }
  return contextValue;
};
exports.useAIForSOCDetailsContext = useAIForSOCDetailsContext;