"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSummarySection = exports.ALERT_SUMMARY_SECTION_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _alert_summary = require("./alert_summary");
var _settings_menu = require("./settings_menu");
var _kibana = require("../../../common/lib/kibana");
var _context = require("../context");
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_SUMMARY_SECTION_TEST_ID = exports.ALERT_SUMMARY_SECTION_TEST_ID = 'ai-for-soc-alert-flyout-alert-summary-section';
const AI_SUMMARY = _i18n.i18n.translate('xpack.securitySolution.alertSummary.aiSummarySection.title', {
  defaultMessage: 'AI summary'
});
/**
 * Alert summary section of the AI for SOC alert summary alert flyout.
 */
const AlertSummarySection = exports.AlertSummarySection = /*#__PURE__*/(0, _react.memo)(({
  getPromptContext
}) => {
  var _capabilities$managem;
  const [hasAlertSummary, setHasAlertSummary] = (0, _react.useState)(false);
  const {
    application: {
      capabilities
    },
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const {
    eventId,
    showAnonymizedValues
  } = (0, _context.useAIForSOCDetailsContext)();
  const canSeeAdvancedSettings = (_capabilities$managem = capabilities.management.kibana.settings) !== null && _capabilities$managem !== void 0 ? _capabilities$managem : false;
  const defaultConnectorId = uiSettings.get(_constants.DEFAULT_AI_CONNECTOR);
  const promptContext = (0, _react.useMemo)(() => ({
    category: 'alert',
    description: 'Alert summary',
    getPromptContext,
    id: `contextId-${eventId}`,
    tooltip: '' // empty as tooltip is only used within Assistant, but in the flyout
  }), [eventId, getPromptContext]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": ALERT_SUMMARY_SECTION_TEST_ID,
    justifyContent: 'spaceBetween'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 's'
  }, /*#__PURE__*/_react.default.createElement("h2", null, AI_SUMMARY))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_settings_menu.AlertSummaryOptionsMenu, {
    hasAlertSummary: hasAlertSummary
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_alert_summary.AlertSummary, {
    alertId: eventId,
    canSeeAdvancedSettings: canSeeAdvancedSettings,
    defaultConnectorId: defaultConnectorId,
    promptContext: promptContext,
    setHasAlertSummary: setHasAlertSummary,
    showAnonymizedValues: showAnonymizedValues
  }));
});
AlertSummarySection.displayName = 'AlertSummarySection';