"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.networkReducer = exports.initialNetworkState = void 0;
var _typescriptFsaReducers = require("typescript-fsa-reducers");
var _fp = require("@kbn/safer-lodash-set/fp");
var _fp2 = require("lodash/fp");
var _search_strategy = require("../../../../common/search_strategy");
var _constants = require("../../../common/store/constants");
var _actions = require("./actions");
var _helpers = require("./helpers");
var _model = require("./model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialNetworkState = exports.initialNetworkState = {
  page: {
    queries: {
      [_model.NetworkTableType.topNFlowSource]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          field: _search_strategy.NetworkTopTablesFields.bytes_out,
          direction: _search_strategy.Direction.desc
        }
      },
      [_model.NetworkTableType.topNFlowDestination]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          field: _search_strategy.NetworkTopTablesFields.bytes_in,
          direction: _search_strategy.Direction.desc
        }
      },
      [_model.NetworkTableType.dns]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          field: _search_strategy.NetworkDnsFields.uniqueDomains,
          direction: _search_strategy.Direction.desc
        },
        isPtrIncluded: false
      },
      [_model.NetworkTableType.http]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          direction: _search_strategy.Direction.desc
        }
      },
      [_model.NetworkTableType.tls]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          field: _search_strategy.NetworkTlsFields._id,
          direction: _search_strategy.Direction.desc
        }
      },
      [_model.NetworkTableType.topCountriesSource]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          field: _search_strategy.NetworkTopTablesFields.bytes_out,
          direction: _search_strategy.Direction.desc
        }
      },
      [_model.NetworkTableType.topCountriesDestination]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          field: _search_strategy.NetworkTopTablesFields.bytes_in,
          direction: _search_strategy.Direction.desc
        }
      },
      [_model.NetworkTableType.alerts]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT
      },
      [_model.NetworkTableType.anomalies]: {
        jobIdSelection: [],
        intervalSelection: 'auto'
      }
    }
  },
  details: {
    queries: {
      [_model.NetworkDetailsTableType.http]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          direction: _search_strategy.Direction.desc
        }
      },
      [_model.NetworkDetailsTableType.topCountriesSource]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          field: _search_strategy.NetworkTopTablesFields.bytes_out,
          direction: _search_strategy.Direction.desc
        }
      },
      [_model.NetworkDetailsTableType.topCountriesDestination]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          field: _search_strategy.NetworkTopTablesFields.bytes_in,
          direction: _search_strategy.Direction.desc
        }
      },
      [_model.NetworkDetailsTableType.topNFlowSource]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          field: _search_strategy.NetworkTopTablesFields.bytes_out,
          direction: _search_strategy.Direction.desc
        }
      },
      [_model.NetworkDetailsTableType.topNFlowDestination]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          field: _search_strategy.NetworkTopTablesFields.bytes_in,
          direction: _search_strategy.Direction.desc
        }
      },
      [_model.NetworkDetailsTableType.tls]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          field: _search_strategy.NetworkTlsFields._id,
          direction: _search_strategy.Direction.desc
        }
      },
      [_model.NetworkDetailsTableType.users]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          field: _search_strategy.NetworkUsersFields.name,
          direction: _search_strategy.Direction.asc
        }
      },
      [_model.NetworkDetailsTableType.anomalies]: {
        jobIdSelection: [],
        intervalSelection: 'auto'
      }
    },
    flowTarget: _search_strategy.FlowTarget.source
  }
};
const networkReducer = exports.networkReducer = (0, _typescriptFsaReducers.reducerWithInitialState)(initialNetworkState).case(_actions.updateNetworkTable, (state, {
  networkType,
  tableType,
  updates
}) => ({
  ...state,
  [networkType]: {
    ...state[networkType],
    queries: {
      ...state[networkType].queries,
      [tableType]: {
        ...(0, _fp2.get)([networkType, 'queries', tableType], state),
        ...updates
      }
    }
  }
})).case(_actions.setNetworkTablesActivePageToZero, state => ({
  ...state,
  page: {
    ...state.page,
    queries: (0, _helpers.setNetworkPageQueriesActivePageToZero)(state)
  },
  details: {
    ...state.details,
    queries: (0, _helpers.setNetworkDetailsQueriesActivePageToZero)(state)
  }
})).case(_actions.setNetworkDetailsTablesActivePageToZero, state => ({
  ...state,
  details: {
    ...state.details,
    queries: (0, _helpers.setNetworkDetailsQueriesActivePageToZero)(state)
  }
})).case(_actions.updateNetworkAnomaliesJobIdFilter, (state, {
  jobIds,
  networkType
}) => {
  if (networkType === _model.NetworkType.page) {
    return (0, _fp.set)('page.queries.anomalies.jobIdSelection', jobIds, state);
  } else {
    return (0, _fp.set)('details.queries.anomalies.jobIdSelection', jobIds, state);
  }
}).case(_actions.updateNetworkAnomaliesInterval, (state, {
  interval,
  networkType
}) => {
  if (networkType === _model.NetworkType.page) {
    return (0, _fp.set)('page.queries.anomalies.intervalSelection', interval, state);
  } else {
    return (0, _fp.set)('details.queries.anomalies.intervalSelection', interval, state);
  }
}).build();