"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkDetailsTabs = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _anomalies_network_table = require("../../../../common/components/ml/tables/anomalies_network_table");
var _network = require("../../../../../common/search_strategy/security_solution/network");
var _events_query_tab_body = require("../../../../common/components/events_tab/events_query_tab_body");
var _anomalies_query_tab_body = require("../../../../common/containers/anomalies/anomalies_query_tab_body");
var _constants = require("../constants");
var _navigation = require("../navigation");
var _conditional_flex_group = require("../navigation/conditional_flex_group");
var _store = require("../../store");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NetworkDetailsTabs = exports.NetworkDetailsTabs = /*#__PURE__*/_react.default.memo(({
  flowTarget,
  indexPattern,
  networkDetailsFilter,
  ...rest
}) => {
  const type = _store.networkModel.NetworkType.details;
  const commonProps = {
    ...rest,
    type
  };
  const flowTabProps = {
    ...commonProps,
    indexPattern
  };
  const commonPropsWithFlowTarget = {
    ...commonProps,
    flowTarget
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_DETAILS_PAGE_PATH}/:flowTarget/:tabName(${_types.NetworkDetailsRouteType.flows})`
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_conditional_flex_group.ConditionalFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_navigation.IPsQueryTabBody, (0, _extends2.default)({}, flowTabProps, {
    flowTarget: _network.FlowTargetSourceDest.source
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_navigation.IPsQueryTabBody, (0, _extends2.default)({}, flowTabProps, {
    flowTarget: _network.FlowTargetSourceDest.destination
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_conditional_flex_group.ConditionalFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_navigation.CountriesQueryTabBody, (0, _extends2.default)({}, flowTabProps, {
    flowTarget: _network.FlowTargetSourceDest.source
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_navigation.CountriesQueryTabBody, (0, _extends2.default)({}, flowTabProps, {
    flowTarget: _network.FlowTargetSourceDest.destination
  })))))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_DETAILS_PAGE_PATH}/:flowTarget/:tabName(${_types.NetworkDetailsRouteType.users})`
  }, /*#__PURE__*/_react.default.createElement(_navigation.UsersQueryTabBody, commonPropsWithFlowTarget)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_DETAILS_PAGE_PATH}/:flowTarget/:tabName(${_types.NetworkDetailsRouteType.http})`
  }, /*#__PURE__*/_react.default.createElement(_navigation.HttpQueryTabBody, commonProps)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_DETAILS_PAGE_PATH}/:flowTarget/:tabName(${_types.NetworkDetailsRouteType.tls})`
  }, /*#__PURE__*/_react.default.createElement(_navigation.TlsQueryTabBody, commonPropsWithFlowTarget)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_DETAILS_PAGE_PATH}/:flowTarget/:tabName(${_types.NetworkDetailsRouteType.anomalies})`
  }, /*#__PURE__*/_react.default.createElement(_anomalies_query_tab_body.AnomaliesQueryTabBody, (0, _extends2.default)({}, commonPropsWithFlowTarget, {
    hideHistogramIfEmpty: true,
    AnomaliesTableComponent: _anomalies_network_table.AnomaliesNetworkTable
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_DETAILS_PAGE_PATH}/:flowTarget/:tabName(${_types.NetworkDetailsRouteType.events})`
  }, /*#__PURE__*/_react.default.createElement(_events_query_tab_body.EventsQueryTabBody, (0, _extends2.default)({
    additionalFilters: networkDetailsFilter
  }, commonProps, {
    tableId: _securitysolutionDataTable.TableId.networkPageEvents
  }))));
});
NetworkDetailsTabs.displayName = 'UsersDetailsTabs';