"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NETWORK_PATH_WITH_ANOMALIES = exports.NETWORK_PATH_WITHOUT_ANOMALIES = exports.NETWORK_DETAILS_TAB_PATH = exports.NETWORK_DETAILS_PAGE_PATH = exports.FLOW_TARGET_PARAM = void 0;
var _constants = require("../../../../common/constants");
var _search_strategy = require("../../../../common/search_strategy");
var _types = require("./details/types");
var _types2 = require("./navigation/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NETWORK_TABS = [_types2.NetworkRouteType.flows, _types2.NetworkRouteType.dns, _types2.NetworkRouteType.http, _types2.NetworkRouteType.tls, _types2.NetworkRouteType.events];
const NETWORK_WITHOUT_ANOMALIES_TAB_PARAM = NETWORK_TABS.join('|');
const NETWORK_WITH_ANOMALIES_TAB_PARAM = [...NETWORK_TABS, _types2.NetworkRouteType.anomalies].join('|');
const NETWORK_PATH_WITH_ANOMALIES = exports.NETWORK_PATH_WITH_ANOMALIES = `${_constants.NETWORK_PATH}/:tabName(${NETWORK_WITH_ANOMALIES_TAB_PARAM})`;
const NETWORK_PATH_WITHOUT_ANOMALIES = exports.NETWORK_PATH_WITHOUT_ANOMALIES = `${_constants.NETWORK_PATH}/:tabName(${NETWORK_WITHOUT_ANOMALIES_TAB_PARAM})`;
const DETAIL_TABS_PARAM = [_types.NetworkDetailsRouteType.flows, _types.NetworkDetailsRouteType.http, _types.NetworkDetailsRouteType.tls, _types.NetworkDetailsRouteType.anomalies, _types.NetworkDetailsRouteType.events, _types.NetworkDetailsRouteType.users].join('|');
const FLOW_TARGET_PARAM = exports.FLOW_TARGET_PARAM = [_search_strategy.FlowTargetSourceDest.source, _search_strategy.FlowTargetSourceDest.destination].join('|');
const NETWORK_DETAILS_PAGE_PATH = exports.NETWORK_DETAILS_PAGE_PATH = `${_constants.NETWORK_PATH}/ip/:detailName`;
const NETWORK_DETAILS_TAB_PATH = exports.NETWORK_DETAILS_TAB_PATH = `${NETWORK_DETAILS_PAGE_PATH}/:flowTarget(${FLOW_TARGET_PARAM})/:tabName(${DETAIL_TABS_PARAM})`;