"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MANAGE_RULES_SAVE = exports.MANAGE_RULES_DESCRIPTION = exports.MANAGE_RULES_CANCEL = exports.LINK_RULES_OVERFLOW_BUTTON_TITLE = exports.LINK_RULES_HEADER = exports.EXPORT_EXCEPTION_LIST = exports.EXCEPTION_MANAGE_RULES_ERROR_DESCRIPTION = exports.EXCEPTION_MANAGE_RULES_ERROR = exports.EXCEPTION_LIST_SEARCH_ERROR_TITLE = exports.EXCEPTION_LIST_SEARCH_ERROR_BODY = exports.EXCEPTION_LIST_EMPTY_VIEWER_TITLE = exports.EXCEPTION_LIST_EMPTY_VIEWER_BUTTON_ENDPOINT = exports.EXCEPTION_LIST_EMPTY_VIEWER_BUTTON = exports.EXCEPTION_LIST_EMPTY_VIEWER_BODY = exports.EXCEPTION_LIST_EMPTY_SEARCH_BAR_BUTTON_ENDPOINT = exports.EXCEPTION_LIST_EMPTY_SEARCH_BAR_BUTTON = exports.EXCEPTION_LIST_DELETED_SUCCESSFULLY = exports.EXCEPTION_ITEM_DELETE_TITLE = exports.EXCEPTION_ITEM_DELETE_TEXT = exports.EXCEPTION_EXPORT_ERROR_DESCRIPTION = exports.EXCEPTION_ERROR_TITLE = exports.EXCEPTION_ERROR_DESCRIPTION = exports.EXCEPTION_DUPLICATE_ERROR_DESCRIPTION = exports.DUPLICATE_EXCEPTION_LIST = exports.DELETE_EXCEPTION_LIST = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EXCEPTION_LIST_EMPTY_VIEWER_TITLE = exports.EXCEPTION_LIST_EMPTY_VIEWER_TITLE = _i18n.i18n.translate('xpack.securitySolution.exception.list.empty.viewer_title', {
  defaultMessage: 'Create exceptions to this list'
});
const EXCEPTION_LIST_EMPTY_VIEWER_BODY = listName => _i18n.i18n.translate('xpack.securitySolution.exception.list.empty.viewer_body', {
  values: {
    listName
  },
  defaultMessage: 'There is no exception in your [{listName}]. Create rule exceptions to this list.'
});
exports.EXCEPTION_LIST_EMPTY_VIEWER_BODY = EXCEPTION_LIST_EMPTY_VIEWER_BODY;
const EXCEPTION_LIST_EMPTY_VIEWER_BUTTON_ENDPOINT = exports.EXCEPTION_LIST_EMPTY_VIEWER_BUTTON_ENDPOINT = _i18n.i18n.translate('xpack.securitySolution.exception.list.empty.viewer_button_endpoint', {
  defaultMessage: 'Create endpoint exception'
});
const EXCEPTION_LIST_EMPTY_VIEWER_BUTTON = exports.EXCEPTION_LIST_EMPTY_VIEWER_BUTTON = _i18n.i18n.translate('xpack.securitySolution.exception.list.empty.viewer_button', {
  defaultMessage: 'Create rule exception'
});
const EXCEPTION_LIST_EMPTY_SEARCH_BAR_BUTTON_ENDPOINT = exports.EXCEPTION_LIST_EMPTY_SEARCH_BAR_BUTTON_ENDPOINT = _i18n.i18n.translate('xpack.securitySolution.exception.list.search_bar_button_enpoint', {
  defaultMessage: 'Add endpoint exception to list'
});
const EXCEPTION_LIST_EMPTY_SEARCH_BAR_BUTTON = exports.EXCEPTION_LIST_EMPTY_SEARCH_BAR_BUTTON = _i18n.i18n.translate('xpack.securitySolution.exception.list.search_bar_button', {
  defaultMessage: 'Add rule exception to list'
});
const EXCEPTION_LIST_SEARCH_ERROR_TITLE = exports.EXCEPTION_LIST_SEARCH_ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.exceptions.list.exceptionItemSearchErrorTitle', {
  defaultMessage: 'Error searching'
});
const EXCEPTION_LIST_SEARCH_ERROR_BODY = exports.EXCEPTION_LIST_SEARCH_ERROR_BODY = _i18n.i18n.translate('xpack.securitySolution.exceptions.list.exceptionItemSearchErrorBody', {
  defaultMessage: 'An error occurred searching for exception items. Please try again.'
});
const EXCEPTION_ERROR_TITLE = exports.EXCEPTION_ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.exceptions.list.exceptionItemsFetchError', {
  defaultMessage: 'Unable to load exception items'
});
const EXCEPTION_ERROR_DESCRIPTION = exports.EXCEPTION_ERROR_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.exceptions.list.exceptionItemsFetchErrorDescription', {
  defaultMessage: 'There was an error loading the exception items. Contact your administrator for help.'
});
const EXCEPTION_ITEM_DELETE_TITLE = exports.EXCEPTION_ITEM_DELETE_TITLE = _i18n.i18n.translate('xpack.securitySolution.exceptions.list.exception.item.card.exceptionItemDeleteSuccessTitle', {
  defaultMessage: 'Exception deleted'
});
const EXCEPTION_ITEM_DELETE_TEXT = itemName => _i18n.i18n.translate('xpack.securitySolution.exceptions.list.exception.item.card.exceptionItemDeleteSuccessText', {
  values: {
    itemName
  },
  defaultMessage: '"{itemName}" deleted successfully.'
});
exports.EXCEPTION_ITEM_DELETE_TEXT = EXCEPTION_ITEM_DELETE_TEXT;
const EXCEPTION_LIST_DELETED_SUCCESSFULLY = listName => _i18n.i18n.translate('xpack.securitySolution.exceptions.list.deleted_successfully', {
  values: {
    listName
  },
  defaultMessage: '{listName} deleted successfully'
});
exports.EXCEPTION_LIST_DELETED_SUCCESSFULLY = EXCEPTION_LIST_DELETED_SUCCESSFULLY;
const MANAGE_RULES_CANCEL = exports.MANAGE_RULES_CANCEL = _i18n.i18n.translate('xpack.securitySolution.exceptions.list.manage_rules_cancel', {
  defaultMessage: 'Cancel'
});
const MANAGE_RULES_SAVE = exports.MANAGE_RULES_SAVE = _i18n.i18n.translate('xpack.securitySolution.exceptions.list.manage_rules_save', {
  defaultMessage: 'Save'
});
const LINK_RULES_HEADER = exports.LINK_RULES_HEADER = _i18n.i18n.translate('xpack.securitySolution.exceptions.list.link_rules_header', {
  defaultMessage: 'Link rules'
});
const LINK_RULES_OVERFLOW_BUTTON_TITLE = exports.LINK_RULES_OVERFLOW_BUTTON_TITLE = _i18n.i18n.translate('xpack.securitySolution.exceptions.list.link_rules_overflow_button_title', {
  defaultMessage: 'Link rules'
});
const MANAGE_RULES_DESCRIPTION = exports.MANAGE_RULES_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.exceptions.list.manage_rules_description', {
  defaultMessage: 'Link or unlink rules to this exception list.'
});
const DELETE_EXCEPTION_LIST = exports.DELETE_EXCEPTION_LIST = _i18n.i18n.translate('xpack.securitySolution.exceptionsTable.deleteExceptionList', {
  defaultMessage: 'Delete exception list'
});
const EXPORT_EXCEPTION_LIST = exports.EXPORT_EXCEPTION_LIST = _i18n.i18n.translate('xpack.securitySolution.exceptionsTable.exportExceptionList', {
  defaultMessage: 'Export exception list'
});
const EXCEPTION_MANAGE_RULES_ERROR = exports.EXCEPTION_MANAGE_RULES_ERROR = _i18n.i18n.translate('xpack.securitySolution.exceptionsTable.manageRulesError', {
  defaultMessage: 'Manage rules error'
});
const EXCEPTION_MANAGE_RULES_ERROR_DESCRIPTION = exports.EXCEPTION_MANAGE_RULES_ERROR_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.exceptionsTable.manageRulesErrorDescription', {
  defaultMessage: 'An error occurred linking or unlinking rules'
});
const EXCEPTION_EXPORT_ERROR_DESCRIPTION = exports.EXCEPTION_EXPORT_ERROR_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.exceptionsTable.exportListDescription', {
  defaultMessage: 'An error occurred exporting a list'
});
const DUPLICATE_EXCEPTION_LIST = exports.DUPLICATE_EXCEPTION_LIST = _i18n.i18n.translate('xpack.securitySolution.exceptionsTable.duplicateExceptionList', {
  defaultMessage: 'Duplicate exception list'
});
const EXCEPTION_DUPLICATE_ERROR_DESCRIPTION = exports.EXCEPTION_DUPLICATE_ERROR_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.exceptionsTable.duplicateListDescription', {
  defaultMessage: 'An error occurred duplicating a list'
});