"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IncludeExpiredExceptionsModal = exports.CHECK_EXCEPTION_TTL_ACTION_TYPES = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHECK_EXCEPTION_TTL_ACTION_TYPES = exports.CHECK_EXCEPTION_TTL_ACTION_TYPES = {
  DUPLICATE: 'duplicate',
  EXPORT: 'export'
};
const IncludeExpiredExceptionsModal = exports.IncludeExpiredExceptionsModal = /*#__PURE__*/(0, _react.memo)(({
  handleCloseModal,
  onModalConfirm,
  action
}) => {
  const [includeExpired, setIncludeExpired] = (0, _react.useState)(true);
  const handleSwitchChange = (0, _react.useCallback)(() => {
    setIncludeExpired(!includeExpired);
  }, [setIncludeExpired, includeExpired]);
  const handleConfirm = (0, _react.useCallback)(() => {
    onModalConfirm(includeExpired);
    handleCloseModal();
  }, [includeExpired, handleCloseModal, onModalConfirm]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: action === CHECK_EXCEPTION_TTL_ACTION_TYPES.EXPORT ? i18n.EXPIRED_EXCEPTIONS_MODAL_EXPORT_TITLE : i18n.EXPIRED_EXCEPTIONS_MODAL_DUPLICATE_TITLE,
    onCancel: handleCloseModal,
    onConfirm: handleConfirm,
    cancelButtonText: i18n.EXPIRED_EXCEPTIONS_MODAL_CANCEL_BUTTON,
    confirmButtonText: action === CHECK_EXCEPTION_TTL_ACTION_TYPES.EXPORT ? i18n.EXPIRED_EXCEPTIONS_MODAL_CONFIRM_EXPORT_BUTTON : i18n.EXPIRED_EXCEPTIONS_MODAL_CONFIRM_DUPLICATE_BUTTON,
    defaultFocusedButton: "confirm",
    "data-test-subj": "includeExpiredExceptionsConfirmationModal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, action === CHECK_EXCEPTION_TTL_ACTION_TYPES.EXPORT ? i18n.EXPIRED_EXCEPTIONS_MODAL_EXPORT_DESCRIPTION : i18n.EXPIRED_EXCEPTIONS_MODAL_DUPLICATE_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: i18n.EXPIRED_EXCEPTIONS_MODAL_INCLUDE_SWITCH_LABEL,
    checked: includeExpired,
    onChange: handleSwitchChange,
    "data-test-subj": "includeExpiredExceptionsConfirmationModalSwitch"
  }));
});
IncludeExpiredExceptionsModal.displayName = 'IncludeExpiredExceptionsModal';