"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LOADING_INTEGRATIONS_TEST_ID = exports.AlertSummaryPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_find_rules_query = require("../../../detection_engine/rule_management/api/hooks/use_find_rules_query");
var _use_fetch_integrations = require("../../hooks/alert_summary/use_fetch_integrations");
var _landing_page = require("../../components/alert_summary/landing_page/landing_page");
var _wrapper = require("../../components/alert_summary/wrapper");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOADING_INTEGRATIONS_TEST_ID = exports.LOADING_INTEGRATIONS_TEST_ID = 'alert-summary-loading-integrations';
const LOADING_INTEGRATIONS = _i18n.i18n.translate('xpack.securitySolution.alertSummary.loading', {
  defaultMessage: 'Loading integrations'
});

/**
 * Alert summary page rendering alerts generated by AI for SOC integrations.
 * This page should be only rendered for the AI for SOC product line.
 * It fetches all the rules and packages (integration) to pass them down to the rest of the page.
 */
const AlertSummaryPage = exports.AlertSummaryPage = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    availablePackages,
    installedPackages,
    isLoading: integrationIsLoading
  } = (0, _use_fetch_integrations.useFetchIntegrations)();

  // Fetch all rules. For the AI for SOC effort, there should only be one rule per integration (which means for now 5-6 rules total)
  const {
    data,
    isLoading: ruleIsLoading
  } = (0, _use_find_rules_query.useFindRulesQuery)({});
  const ruleResponse = (0, _react.useMemo)(() => ({
    rules: (data === null || data === void 0 ? void 0 : data.rules) || [],
    isLoading: ruleIsLoading
  }), [data, ruleIsLoading]);
  if (integrationIsLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": LOADING_INTEGRATIONS_TEST_ID,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        logo: "logoSecurity",
        size: "xl"
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", null, LOADING_INTEGRATIONS)
    });
  }
  if (installedPackages.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_landing_page.LandingPage, {
      packages: availablePackages
    });
  }
  return /*#__PURE__*/_react.default.createElement(_wrapper.Wrapper, {
    packages: installedPackages,
    ruleResponse: ruleResponse
  });
});
AlertSummaryPage.displayName = 'AlertSummaryPage';