"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsTableFieldsBrowserOptions = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _fields_browser = require("../../../timelines/components/fields_browser");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAlertsTableFieldsBrowserOptions = (scopeId, toggleColumn = _lodash.noop) => {
  const upsertColumn = (0, _react.useCallback)(column => {
    toggleColumn === null || toggleColumn === void 0 ? void 0 : toggleColumn(column.id);
  }, [toggleColumn]);
  const fieldBrowserArgs = (0, _react.useMemo)(() => {
    return {
      sourcererScope: scopeId,
      removeColumn: toggleColumn,
      upsertColumn
    };
  }, [scopeId, toggleColumn, upsertColumn]);
  const options = (0, _fields_browser.useFieldBrowserOptions)(fieldBrowserArgs);
  return (0, _react.useMemo)(() => {
    return {
      createFieldButton: options.createFieldButton
    };
  }, [options.createFieldButton]);
};
exports.useAlertsTableFieldsBrowserOptions = useAlertsTableFieldsBrowserOptions;