"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesFromAlerts = void 0;
var _lodash = require("lodash");
var _react = require("react");
var _constants = require("../../../../../common/constants");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _api = require("./api");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCasesFromAlerts = ({
  alertId
}) => {
  const [loading, setLoading] = (0, _react.useState)(false);
  const [cases, setCases] = (0, _react.useState)([]);
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  (0, _react.useEffect)(() => {
    // isMounted tracks if a component is mounted before changing state
    let isMounted = true;
    setLoading(true);
    const fetchData = async () => {
      try {
        const casesResponse = await (0, _api.getCaseIdsFromAlertId)({
          alertId,
          owner: [_constants.APP_ID]
        });
        if (isMounted) {
          setCases(casesResponse);
        }
      } catch (error) {
        addError(error.message, {
          title: _translations.CASES_FROM_ALERTS_FAILURE
        });
      }
      if (isMounted) {
        setLoading(false);
      }
    };
    if (!(0, _lodash.isEmpty)(alertId)) {
      fetchData();
    }
    return () => {
      // updates to show component is unmounted
      isMounted = false;
    };
  }, [alertId, addError]);
  return {
    loading,
    casesInfo: cases
  };
};
exports.useCasesFromAlerts = useCasesFromAlerts;