"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsGroupingQuery = void 0;
var _grouping = require("@kbn/grouping");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertsGroupingQuery = ({
  additionalFilters,
  from,
  groupStatsAggregations,
  pageIndex,
  pageSize,
  runtimeMappings,
  selectedGroup,
  uniqueValue,
  to
}) => (0, _grouping.getGroupingQuery)({
  additionalFilters,
  from,
  groupByField: selectedGroup,
  statsAggregations: !(0, _grouping.isNoneGroup)([selectedGroup]) ? groupStatsAggregations(selectedGroup) : [],
  pageNumber: pageIndex * pageSize,
  runtimeMappings,
  uniqueValue,
  size: pageSize,
  sort: [{
    unitsCount: {
      order: 'desc'
    }
  }],
  to
});
exports.getAlertsGroupingQuery = getAlertsGroupingQuery;