"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_ALERTS = exports.TOP = exports.SHOWING_ALERTS = exports.NOT_AVAILABLE_TOOLTIP = exports.HISTOGRAM_HEADER = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TOP = fieldName => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.histogram.topNLabel', {
  values: {
    fieldName
  },
  defaultMessage: `Top {fieldName}`
});
exports.TOP = TOP;
const HISTOGRAM_HEADER = exports.HISTOGRAM_HEADER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.histogram.headerTitle', {
  defaultMessage: 'Trend'
});
const NOT_AVAILABLE_TOOLTIP = exports.NOT_AVAILABLE_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.histogram.notAvailableTooltip', {
  defaultMessage: 'Not available for trend view'
});
const VIEW_ALERTS = exports.VIEW_ALERTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.histogram.viewAlertsButtonLabel', {
  defaultMessage: 'View alerts'
});
const SHOWING_ALERTS = (totalAlertsFormatted, totalAlerts, modifier) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.histogram.showingAlertsTitle', {
  values: {
    totalAlertsFormatted,
    totalAlerts,
    modifier
  },
  defaultMessage: 'Showing: {modifier}{totalAlertsFormatted} {totalAlerts, plural, =1 {alert} other {alerts}}'
});
exports.SHOWING_ALERTS = SHOWING_ALERTS;