"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseAlertsRuleData = exports.getIsAlertsByRuleData = exports.getIsAlertsByRuleAgg = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseAlertsRuleData = response => {
  var _response$aggregation, _response$aggregation2, _response$aggregation3;
  const rulesBuckets = (_response$aggregation = response === null || response === void 0 ? void 0 : (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : (_response$aggregation3 = _response$aggregation2.alertsByRule) === null || _response$aggregation3 === void 0 ? void 0 : _response$aggregation3.buckets) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
  return rulesBuckets.length === 0 ? [] : rulesBuckets.map(rule => {
    return {
      rule: rule.key,
      value: rule.doc_count
    };
  });
};
exports.parseAlertsRuleData = parseAlertsRuleData;
const getIsAlertsByRuleData = data => {
  return data.length > 0 && data.every(x => (0, _lodash.has)(x, 'rule'));
};
exports.getIsAlertsByRuleData = getIsAlertsByRuleData;
const getIsAlertsByRuleAgg = data => {
  return (0, _lodash.has)(data, 'aggregations.alertsByRule');
};
exports.getIsAlertsByRuleAgg = getIsAlertsByRuleAgg;