"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupStatsAggregations = void 0;
var _alerts_grouping = require("../../alerts_table/alerts_grouping");
var _grouping_settings = require("../../alerts_table/grouping_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_SIGNAL_ID_SUB_AGGREGATION = {
  signalRuleIdSubAggregation: {
    terms: {
      field: 'signal.rule.rule_id'
    }
  }
};

/**
 * Returns aggregations to be used to calculate the statistics to be used in the`extraAction` property of the EuiAccordion component.
 * It handles custom renders for the following fields:
 * - signal.rule.rule_id
 * - kibana.alert.severity
 * - kibana.alert.rule.name
 * And returns a default set of aggregation for all the other fields.
 *
 * These go hand in hand with groupingOptions and groupPanelRenderers.
 */
const groupStatsAggregations = field => {
  const aggMetrics = (0, _alerts_grouping.DEFAULT_GROUP_STATS_AGGREGATION)('');
  switch (field) {
    case 'signal.rule.rule_id':
      aggMetrics.push(_grouping_settings.SEVERITY_SUB_AGGREGATION, _grouping_settings.RULE_COUNT_AGGREGATION);
      break;
    case 'kibana.alert.severity':
      aggMetrics.push(RULE_SIGNAL_ID_SUB_AGGREGATION, _grouping_settings.RULE_COUNT_AGGREGATION);
      break;
    case 'kibana.alert.rule.name':
      aggMetrics.push(RULE_SIGNAL_ID_SUB_AGGREGATION, _grouping_settings.SEVERITY_SUB_AGGREGATION);
      break;
    default:
      aggMetrics.push(RULE_SIGNAL_ID_SUB_AGGREGATION, _grouping_settings.SEVERITY_SUB_AGGREGATION, _grouping_settings.RULE_COUNT_AGGREGATION);
  }
  return aggMetrics;
};
exports.groupStatsAggregations = groupStatsAggregations;