"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointActionText = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../../management/common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointActionTextComponent = ({
  name,
  isDisabled
}) => {
  const {
    title,
    description,
    tooltip
  } = useGetCommandText(name);
  const content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("b", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, description));
  if (isDisabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: tooltip
    }, content);
  }
  return content;
};
const useGetCommandText = name => {
  switch (name) {
    case 'isolate':
      return {
        title: _translations.CONSOLE_COMMANDS.isolate.title,
        description: _translations.CONSOLE_COMMANDS.isolate.about,
        tooltip: _translations.CONSOLE_COMMANDS.isolate.privileges
      };
    case 'kill-process':
      return {
        title: _translations.CONSOLE_COMMANDS.killProcess.title,
        description: _translations.CONSOLE_COMMANDS.killProcess.about,
        tooltip: _translations.CONSOLE_COMMANDS.killProcess.privileges
      };
    case 'suspend-process':
      return {
        title: _translations.CONSOLE_COMMANDS.suspendProcess.title,
        description: _translations.CONSOLE_COMMANDS.suspendProcess.about,
        tooltip: _translations.CONSOLE_COMMANDS.suspendProcess.privileges
      };
    default:
      return {
        title: '',
        description: '',
        tooltip: ''
      };
  }
};
const EndpointActionText = exports.EndpointActionText = /*#__PURE__*/_react.default.memo(EndpointActionTextComponent);