"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddRulesPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _helpers = require("../../../common/helpers");
var _types = require("../../../../app/types");
var _header_page = require("../../../../common/components/header_page");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _kibana = require("../../../../common/lib/kibana");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _user_info = require("../../../../detections/components/user_info");
var _use_lists_config = require("../../../../detections/containers/detection_engine/lists/use_lists_config");
var i18n = _interopRequireWildcard(require("./translations"));
var _add_prebuilt_rules_table = require("../../components/rules_table/add_prebuilt_rules_table/add_prebuilt_rules_table");
var _add_prebuilt_rules_table_context = require("../../components/rules_table/add_prebuilt_rules_table/add_prebuilt_rules_table_context");
var _add_prebuilt_rules_header_buttons = require("../../components/rules_table/add_prebuilt_rules_table/add_prebuilt_rules_header_buttons");
var _common = require("../../../../../common");
var _need_admin_for_update_callout = require("../../../../detections/components/callouts/need_admin_for_update_callout");
var _missing_privileges_callout = require("../../../../detections/components/callouts/missing_privileges_callout");
var _link_to = require("../../../../common/components/link_to");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddRulesPageComponent = () => {
  const {
    navigateToApp
  } = (0, _kibana.useKibana)().services.application;
  const [{
    isSignalIndexExists,
    isAuthenticated,
    hasEncryptionKey
  }] = (0, _user_info.useUserData)();
  const {
    needsConfiguration: needsListsConfiguration
  } = (0, _use_lists_config.useListsConfig)();
  if ((0, _helpers.redirectToDetections)(isSignalIndexExists, isAuthenticated, hasEncryptionKey, needsListsConfiguration)) {
    navigateToApp(_common.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.alerts,
      path: (0, _link_to.getDetectionEngineUrl)()
    });
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_need_admin_for_update_callout.NeedAdminForUpdateRulesCallOut, null), /*#__PURE__*/_react.default.createElement(_missing_privileges_callout.MissingPrivilegesCallOut, null), /*#__PURE__*/_react.default.createElement(_add_prebuilt_rules_table_context.AddPrebuiltRulesTableContextProvider, null, /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: i18n.PAGE_TITLE
  }, /*#__PURE__*/_react.default.createElement(_add_prebuilt_rules_header_buttons.AddPrebuiltRulesHeaderButtons, null)), /*#__PURE__*/_react.default.createElement(_add_prebuilt_rules_table.AddPrebuiltRulesTable, null))), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.rulesAdd
  }));
};
const AddRulesPage = exports.AddRulesPage = /*#__PURE__*/_react.default.memo(AddRulesPageComponent);
AddRulesPage.displayName = 'AddRulesPage';