"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRulesTableSavedState = useRulesTableSavedState;
var _zodHelpers = require("@kbn/zod-helpers");
var _helpers = require("../../../../../common/utils/global_query_string/helpers");
var _constants = require("../../../../../../common/constants");
var _kibana = require("../../../../../common/lib/kibana");
var _use_url_state = require("../../../../../common/hooks/use_url_state");
var _constants2 = require("../constants");
var _rules_table_saved_state = require("./rules_table_saved_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function readStorageState(storage) {
  try {
    return storage.get(_constants2.RULES_TABLE_STATE_STORAGE_KEY);
  } catch {
    return null;
  }
}
function useRulesTableSavedState() {
  const getUrlParam = (0, _helpers.useGetInitialUrlParamValue)(_use_url_state.URL_PARAM_KEY.rulesTable);
  const {
    services: {
      sessionStorage
    }
  } = (0, _kibana.useKibana)();
  const urlState = getUrlParam();
  const storageState = readStorageState(sessionStorage);
  if (!urlState && !storageState) {
    return {};
  }
  const [filter, sorting, pagination] = validateState(urlState, storageState);
  return {
    filter,
    sorting,
    pagination
  };
}
function validateState(urlState, storageState) {
  var _filterFromUrl$search, _filterFromUrl$source, _filterFromUrl$tags, _filterFromUrl$enable, _filterFromUrl$ruleEx, _sortingFromUrl$field, _sortingFromUrl$order, _paginationFromUrl$pe;
  const filterFromUrl = (0, _zodHelpers.safeParseResult)(urlState, _rules_table_saved_state.RulesTableSavedFilter);
  const filterFromStorage = (0, _zodHelpers.safeParseResult)(storageState, _rules_table_saved_state.RulesTableSavedFilter);
  // We have to expose filter, sorting and pagination objects by explicitly specifying each field
  // since urlState and/or storageState may contain unnecessary fields (e.g. outdated or explicitly added by user)
  // and validateNonExact doesn't truncate fields not included in the type RulesTableSavedFilter and etc.
  const filter = {
    searchTerm: (_filterFromUrl$search = filterFromUrl === null || filterFromUrl === void 0 ? void 0 : filterFromUrl.searchTerm) !== null && _filterFromUrl$search !== void 0 ? _filterFromUrl$search : filterFromStorage === null || filterFromStorage === void 0 ? void 0 : filterFromStorage.searchTerm,
    source: (_filterFromUrl$source = filterFromUrl === null || filterFromUrl === void 0 ? void 0 : filterFromUrl.source) !== null && _filterFromUrl$source !== void 0 ? _filterFromUrl$source : filterFromStorage === null || filterFromStorage === void 0 ? void 0 : filterFromStorage.source,
    tags: (_filterFromUrl$tags = filterFromUrl === null || filterFromUrl === void 0 ? void 0 : filterFromUrl.tags) !== null && _filterFromUrl$tags !== void 0 ? _filterFromUrl$tags : filterFromStorage === null || filterFromStorage === void 0 ? void 0 : filterFromStorage.tags,
    enabled: (_filterFromUrl$enable = filterFromUrl === null || filterFromUrl === void 0 ? void 0 : filterFromUrl.enabled) !== null && _filterFromUrl$enable !== void 0 ? _filterFromUrl$enable : filterFromStorage === null || filterFromStorage === void 0 ? void 0 : filterFromStorage.enabled,
    ruleExecutionStatus: (_filterFromUrl$ruleEx = filterFromUrl === null || filterFromUrl === void 0 ? void 0 : filterFromUrl.ruleExecutionStatus) !== null && _filterFromUrl$ruleEx !== void 0 ? _filterFromUrl$ruleEx : filterFromStorage === null || filterFromStorage === void 0 ? void 0 : filterFromStorage.ruleExecutionStatus
  };
  const sortingFromUrl = (0, _zodHelpers.safeParseResult)(urlState, _rules_table_saved_state.RulesTableSavedSorting);
  const sortingFromStorage = (0, _zodHelpers.safeParseResult)(storageState, _rules_table_saved_state.RulesTableSavedSorting);
  const sorting = {
    field: (_sortingFromUrl$field = sortingFromUrl === null || sortingFromUrl === void 0 ? void 0 : sortingFromUrl.field) !== null && _sortingFromUrl$field !== void 0 ? _sortingFromUrl$field : sortingFromStorage === null || sortingFromStorage === void 0 ? void 0 : sortingFromStorage.field,
    order: (_sortingFromUrl$order = sortingFromUrl === null || sortingFromUrl === void 0 ? void 0 : sortingFromUrl.order) !== null && _sortingFromUrl$order !== void 0 ? _sortingFromUrl$order : sortingFromStorage === null || sortingFromStorage === void 0 ? void 0 : sortingFromStorage.order
  };
  const paginationFromUrl = (0, _zodHelpers.safeParseResult)(urlState, _rules_table_saved_state.RulesTableUrlSavedPagination);
  const paginationFromStorage = (0, _zodHelpers.safeParseResult)(storageState, _rules_table_saved_state.RulesTableStorageSavedPagination);
  const pagination = {
    page: paginationFromUrl === null || paginationFromUrl === void 0 ? void 0 : paginationFromUrl.page,
    // We don't persist page number in the session storage since it may be outdated when restored
    perPage: (_paginationFromUrl$pe = paginationFromUrl === null || paginationFromUrl === void 0 ? void 0 : paginationFromUrl.perPage) !== null && _paginationFromUrl$pe !== void 0 ? _paginationFromUrl$pe : paginationFromStorage === null || paginationFromStorage === void 0 ? void 0 : paginationFromStorage.perPage
  };
  if (pagination.perPage && (pagination.perPage < 0 || pagination.perPage > _constants.RULES_TABLE_MAX_PAGE_SIZE)) {
    delete pagination.perPage;
  }
  return [filter, sorting, pagination];
}