"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowBulkSuccessToast = useShowBulkSuccessToast;
var _react = require("react");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _rule_management = require("../../../../../common/api/detection_engine/rule_management");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useShowBulkSuccessToast() {
  const toasts = (0, _use_app_toasts.useAppToasts)();
  return (0, _react.useCallback)(({
    actionType,
    summary,
    editPayload
  }) => {
    const text = actionType === _rule_management.BulkActionTypeEnum.edit ? (0, _translations.explainBulkEditSuccess)(editPayload !== null && editPayload !== void 0 ? editPayload : [], summary) : (0, _translations.explainBulkSuccess)(actionType, summary);
    const toastBody = {
      title: (0, _translations.summarizeBulkSuccess)(actionType, summary),
      text
    };
    const shouldShowSuccessToast = summary.succeeded >= 1;
    if (shouldShowSuccessToast) {
      toasts.addSuccess(toastBody);
    } else {
      // In the case when the succeeded count is 0, show a neutral toast instead.
      // This can happen when all elements in the bulk action were skipped.
      toasts.addInfo(toastBody);
    }
  }, [toasts]);
}