"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleUpgradeCallout = RuleUpgradeCallout;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _action_required = require("../badges/action_required");
var _review_required_badge = require("../badges/review_required_badge");
var _ready_for_upgrade_badge = require("../badges/ready_for_upgrade_badge");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RuleUpgradeCallout({
  numOfSolvableConflicts,
  numOfNonSolvableConflicts
}) {
  if (numOfNonSolvableConflicts > 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, i18n.UPGRADE_STATUS), "\xA0", /*#__PURE__*/_react.default.createElement(_action_required.ActionRequiredBadge, null), "\xA0", i18n.RULE_HAS_CONFLICTS(numOfNonSolvableConflicts + numOfSolvableConflicts)),
      color: "danger",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("span", null, i18n.RULE_HAS_HARD_CONFLICTS_DESCRIPTION), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, i18n.RULE_HAS_HARD_CONFLICTS_KEEP_YOUR_CHANGES), /*#__PURE__*/_react.default.createElement("li", null, i18n.RULE_HAS_HARD_CONFLICTS_ACCEPT_ELASTIC_UPDATE), /*#__PURE__*/_react.default.createElement("li", null, i18n.RULE_HAS_HARD_CONFLICTS_EDIT_FINAL_VERSION))));
  }
  if (numOfSolvableConflicts > 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, i18n.UPGRADE_STATUS), "\xA0", /*#__PURE__*/_react.default.createElement(_review_required_badge.ReviewRequiredBadge, null), "\xA0", i18n.RULE_HAS_CONFLICTS(numOfSolvableConflicts)),
      color: "warning",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("span", null, i18n.RULE_HAS_SOFT_CONFLICTS_DESCRIPTION), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, i18n.RULE_HAS_SOFT_CONFLICTS_ACCEPT_SUGGESTED_UPDATE), /*#__PURE__*/_react.default.createElement("li", null, i18n.RULE_HAS_SOFT_CONFLICTS_EDIT_FINAL_VERSION))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, i18n.UPGRADE_STATUS), "\xA0", /*#__PURE__*/_react.default.createElement(_ready_for_upgrade_badge.ReadyForUpgradeBadge, null)),
    color: "success",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.RULE_IS_READY_FOR_UPGRADE_DESCRIPTION)));
}