"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThresholdRuleFieldReadOnly = ThresholdRuleFieldReadOnly;
var _react = _interopRequireDefault(require("react"));
var _data_source = require("./fields/data_source/data_source");
var _kql_query = require("./fields/kql_query");
var _type = require("./fields/type/type");
var _alert_suppression = require("./fields/alert_suppression/alert_suppression");
var _utility_types = require("../../../../../../../common/utility_types");
var _threshold = require("./fields/threshold/threshold");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ThresholdRuleFieldReadOnly({
  fieldName,
  finalDiffableRule
}) {
  switch (fieldName) {
    case 'alert_suppression':
      return /*#__PURE__*/_react.default.createElement(_alert_suppression.AlertSuppressionReadOnly, {
        alertSuppression: finalDiffableRule.alert_suppression,
        ruleType: finalDiffableRule.type
      });
    case 'data_source':
      return /*#__PURE__*/_react.default.createElement(_data_source.DataSourceReadOnly, {
        dataSource: finalDiffableRule.data_source
      });
    case 'kql_query':
      return /*#__PURE__*/_react.default.createElement(_kql_query.KqlQueryReadOnly, {
        kqlQuery: finalDiffableRule.kql_query,
        dataSource: finalDiffableRule.data_source,
        ruleType: finalDiffableRule.type
      });
    case 'threshold':
      return /*#__PURE__*/_react.default.createElement(_threshold.ThresholdReadOnly, {
        threshold: finalDiffableRule.threshold
      });
    case 'type':
      return /*#__PURE__*/_react.default.createElement(_type.TypeReadOnly, {
        type: finalDiffableRule.type
      });
    default:
      return (0, _utility_types.assertUnreachable)(fieldName);
  }
}