"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedKqlQueryReadOnly = SavedKqlQueryReadOnly;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _rule_definition_section = require("../../../../rule_definition_section");
var ruleDetailsI18n = _interopRequireWildcard(require("../../../../translations"));
var descriptionStepI18n = _interopRequireWildcard(require("../../../../../../../rule_creation_ui/components/description_step/translations"));
var _use_get_saved_query = require("../../../../../../../common/use_get_saved_query");
var _helpers = require("../../../../helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SavedKqlQueryReadOnly({
  kqlQuery,
  dataSource,
  ruleType
}) {
  var _savedQuery$attribute;
  const {
    savedQuery
  } = (0, _use_get_saved_query.useGetSavedQuery)({
    savedQueryId: kqlQuery.saved_query_id,
    ruleType
  });
  if (!savedQuery) {
    return null;
  }
  const listItems = [{
    title: descriptionStepI18n.SAVED_QUERY_NAME_LABEL,
    description: /*#__PURE__*/_react.default.createElement(_rule_definition_section.SavedQueryName, {
      savedQueryName: savedQuery.attributes.title
    })
  }, {
    title: ruleDetailsI18n.SAVED_QUERY_LANGUAGE_LABEL,
    description: (0, _helpers.getQueryLanguageLabel)(savedQuery.attributes.query.language)
  }];
  if (typeof savedQuery.attributes.query.query === 'string') {
    listItems.push({
      title: descriptionStepI18n.SAVED_QUERY_LABEL,
      description: /*#__PURE__*/_react.default.createElement(_rule_definition_section.Query, {
        query: savedQuery.attributes.query.query
      })
    });
  }
  const filters = (_savedQuery$attribute = savedQuery.attributes.filters) !== null && _savedQuery$attribute !== void 0 ? _savedQuery$attribute : [];
  if ((0, _helpers.isFilters)(filters) && filters.length > 0) {
    const dataSourceProps = (0, _helpers.getDataSourceProps)(dataSource);
    listItems.push({
      title: descriptionStepI18n.SAVED_QUERY_FILTERS_LABEL,
      description: /*#__PURE__*/_react.default.createElement(_rule_definition_section.Filters, (0, _extends2.default)({
        filters: filters
      }, dataSourceProps))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: listItems
  });
}