"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldFinalSideHeader = FieldFinalSideHeader;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _field_upgrade_side_header = require("../../field_upgrade_side_header");
var _utility_types = require("../../../../../../../../common/utility_types");
var _field_upgrade_context = require("../../rule_upgrade/field_upgrade_context");
var _field_edit_form_context = require("../context/field_edit_form_context");
var _field_final_side_help_info = require("./field_final_side_help_info");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FieldFinalSideHeader() {
  const {
    fieldName,
    hasConflict,
    rightSideMode,
    finalDiffableRule,
    setRuleFieldResolvedValue
  } = (0, _field_upgrade_context.useFieldUpgradeContext)();
  const {
    form
  } = (0, _field_edit_form_context.useFieldEditFormContext)();
  const handleAccept = (0, _react.useCallback)(() => setRuleFieldResolvedValue({
    ruleId: finalDiffableRule.rule_id,
    fieldName: fieldName,
    resolvedValue: finalDiffableRule[fieldName]
  }), [finalDiffableRule, fieldName, setRuleFieldResolvedValue]);
  const handleSave = (0, _react.useCallback)(() => form === null || form === void 0 ? void 0 : form.submit(), [form]);
  switch (rightSideMode) {
    case _field_upgrade_context.FieldFinalSideMode.Readonly:
      return /*#__PURE__*/_react.default.createElement(_field_upgrade_side_header.FieldUpgradeSideHeader, null, /*#__PURE__*/_react.default.createElement(StaticHeaderContent, null, hasConflict && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconType: "checkInCircleFilled",
        size: "s",
        onClick: handleAccept,
        "data-test-subj": "prebuilt-rule-upgrade-flyout-field-accept"
      }, i18n.ACCEPT)));
    case _field_upgrade_context.FieldFinalSideMode.Edit:
      return /*#__PURE__*/_react.default.createElement(_field_upgrade_side_header.FieldUpgradeSideHeader, null, /*#__PURE__*/_react.default.createElement(StaticHeaderContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconType: "checkInCircleFilled",
        size: "s",
        disabled: !(form !== null && form !== void 0 && form.isValid),
        onClick: handleSave,
        "data-test-subj": "prebuilt-rule-upgrade-flyout-field-save"
      }, hasConflict ? i18n.SAVE_AND_ACCEPT : i18n.SAVE)));
    default:
      return (0, _utility_types.assertUnreachable)(rightSideMode);
  }
}
function StaticHeaderContent({
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "stretch",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, i18n.FINAL_UPDATE, /*#__PURE__*/_react.default.createElement(_field_final_side_help_info.FieldFinalSideHelpInfo, null))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, children));
}