"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubfieldChangesForRuleNameOverride = void 0;
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSubfieldChangesForRuleNameOverride = (oldFieldValue, newFieldValue) => {
  const oldFieldName = (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.field_name);
  const newFieldName = (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.field_name);
  if (oldFieldName !== newFieldName) {
    return [{
      subfieldName: 'field_name',
      oldSubfieldValue: oldFieldName,
      newSubfieldValue: newFieldName
    }];
  }
  return [];
};
exports.getSubfieldChangesForRuleNameOverride = getSubfieldChangesForRuleNameOverride;