"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubfieldChangesForDataSource = void 0;
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSubfieldChangesForDataSource = (oldFieldValue, newFieldValue) => {
  const changes = [];
  const oldType = (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.type);
  const newType = (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.type);
  if (oldType !== newType) {
    changes.push({
      subfieldName: 'type',
      oldSubfieldValue: oldType,
      newSubfieldValue: newType
    });
  }
  const oldIndexPatterns = (0, _utils.stringifyToSortedJson)((oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.type) === 'index_patterns' ? oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.index_patterns : '');
  const newIndexPatterns = (0, _utils.stringifyToSortedJson)((newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.type) === 'index_patterns' ? newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.index_patterns : '');
  if (oldIndexPatterns !== newIndexPatterns) {
    changes.push({
      subfieldName: 'index_patterns',
      oldSubfieldValue: oldIndexPatterns,
      newSubfieldValue: newIndexPatterns
    });
  }
  const oldDataViewId = (0, _utils.stringifyToSortedJson)((oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.type) === 'data_view' ? oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.data_view_id : '');
  const newDataViewId = (0, _utils.stringifyToSortedJson)((newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.type) === 'data_view' ? newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.data_view_id : '');
  if (oldDataViewId !== newDataViewId) {
    changes.push({
      subfieldName: 'data_view_id',
      oldSubfieldValue: oldDataViewId,
      newSubfieldValue: newDataViewId
    });
  }
  return changes;
};
exports.getSubfieldChangesForDataSource = getSubfieldChangesForDataSource;