"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldComparisonSide = FieldComparisonSide;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _versions_picker = require("./versions_picker/versions_picker");
var _field_upgrade_side_header = require("../field_upgrade_side_header");
var _field_upgrade_context = require("../rule_upgrade/field_upgrade_context");
var _utils = require("./utils");
var _get_subfield_changes = require("./get_subfield_changes");
var _subfield_changes = require("./subfield_changes");
var _comparison_side_help_info = require("./comparison_side_help_info");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FieldComparisonSide() {
  const {
    fieldName,
    fieldDiff,
    finalDiffableRule,
    hasResolvedValueDifferentFromSuggested
  } = (0, _field_upgrade_context.useFieldUpgradeContext)();
  const resolvedValue = finalDiffableRule[fieldName];
  const options = (0, _utils.getComparisonOptionsForDiffOutcome)(fieldDiff.diff_outcome, fieldDiff.conflict, hasResolvedValueDifferentFromSuggested);
  const [selectedOption, setSelectedOption] = (0, _react.useState)(options[0]);
  const [oldVersionType, newVersionType] = (0, _utils.getVersionsForComparison)(selectedOption, fieldDiff.has_base_version);
  const oldFieldValue = (0, _utils.pickFieldValueForVersion)(oldVersionType, fieldDiff, resolvedValue);
  const newFieldValue = (0, _utils.pickFieldValueForVersion)(newVersionType, fieldDiff, resolvedValue);
  const subfieldChanges = (0, _get_subfield_changes.getSubfieldChanges)(fieldName, oldFieldValue, newFieldValue);

  /* Change selected option to "My changes" if user has modified resolved value */
  const prevResolvedValue = (0, _usePrevious.default)(resolvedValue);
  (0, _react.useEffect)(() => {
    if (selectedOption !== _versions_picker.VersionsPickerOptionEnum.MyChanges && prevResolvedValue !== undefined && !(0, _lodash.isEqual)(prevResolvedValue, resolvedValue)) {
      setSelectedOption(_versions_picker.VersionsPickerOptionEnum.MyChanges);
    }
  }, [selectedOption, prevResolvedValue, resolvedValue]);
  return /*#__PURE__*/_react.default.createElement("section", {
    "data-test-subj": `${(0, _lodash.snakeCase)(fieldName)}-comparisonSide`
  }, /*#__PURE__*/_react.default.createElement(_field_upgrade_side_header.FieldUpgradeSideHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, i18n.TITLE, /*#__PURE__*/_react.default.createElement(_comparison_side_help_info.ComparisonSideHelpInfo, {
    options: options
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_versions_picker.VersionsPicker, {
    options: options,
    selectedOption: selectedOption,
    onChange: setSelectedOption
  })))), /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaSectionErrorBoundary, {
    sectionName: i18n.TITLE
  }, /*#__PURE__*/_react.default.createElement(_subfield_changes.SubfieldChanges, {
    fieldName: fieldName,
    subfieldChanges: subfieldChanges
  })));
}