"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GAP_STATUS_UNFILLED = exports.GAP_STATUS_PARTIALLY_FILLED = exports.GAP_STATUS_FILTER_TITLE = exports.GAP_STATUS_FILLED = exports.GAP_FILL_REQUEST_SUCCESS_MESSAGE_TOOLTIP = exports.GAP_FILL_REQUEST_SUCCESS_MESSAGE = exports.GAP_FILL_REQUEST_ERROR_MESSAGE = exports.GAP_FILL_DISABLED_MESSAGE = exports.GAPS_TABLE_TOTAL_GAPS_LABEL = exports.GAPS_TABLE_STATUS_LABEL_TOOLTIP = exports.GAPS_TABLE_STATUS_LABEL = exports.GAPS_TABLE_MANUAL_FILL_TASKS_LABEL_TOOLTIP = exports.GAPS_TABLE_MANUAL_FILL_TASKS_LABEL = exports.GAPS_TABLE_IN_PROGRESS_LABEL = exports.GAPS_TABLE_GAP_RANGE_LABEL_TOOLTIP = exports.GAPS_TABLE_GAP_RANGE_LABEL = exports.GAPS_TABLE_GAP_DURATION_LABEL_TOOLTIP = exports.GAPS_TABLE_GAP_DURATION_LABEL = exports.GAPS_TABLE_FILL_REMAINING_GAP_BUTTON_LABEL = exports.GAPS_TABLE_FILL_GAP_BUTTON_LABEL = exports.GAPS_TABLE_EVENT_TIME_LABEL_TOOLTIP = exports.GAPS_TABLE_EVENT_TIME_LABEL = exports.GAPS_TABLE_EVENT_TIME_COVERED_LABEL_TOOLTIP = exports.GAPS_TABLE_EVENT_TIME_COVERED_LABEL = exports.GAPS_TABLE_ACTIONS_LABEL = exports.GAPS_FILL_ALL_GAPS_WARNING_TOAST_TITLE = exports.GAPS_FILL_ALL_GAPS_WARNING_TOAST_NOTIFY = exports.GAPS_FILL_ALL_GAPS_WARNING_TOAST_DESCRIPTION = exports.GAPS_FILL_ALL_GAPS_UNKNOWN_ERROR_MESSAGE = exports.GAPS_FILL_ALL_GAPS_ERROR_DISABLED_RULE_MESSAGE = exports.GAPS_FILL_ALL_GAPS_DRY_RUN_MODAL_HEADING = exports.GAPS_FILL_ALL_GAPS_DRY_RUN_FAILED_MODAL_CLOSE_BUTTON_LABEL = exports.GAPS_FILL_ALL_GAPS_BUTTON_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GAPS_TABLE_STATUS_LABEL = exports.GAPS_TABLE_STATUS_LABEL = _i18n.i18n.translate('xpack.securitySolution.gapsTable.statusLabel', {
  defaultMessage: 'Status'
});
const GAPS_TABLE_STATUS_LABEL_TOOLTIP = exports.GAPS_TABLE_STATUS_LABEL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.gapsTable.statusLabelTooltip', {
  defaultMessage: 'Status of gap'
});
const GAPS_TABLE_ACTIONS_LABEL = exports.GAPS_TABLE_ACTIONS_LABEL = _i18n.i18n.translate('xpack.securitySolution.gapsTable.actionsLabel', {
  defaultMessage: 'Actions'
});
const GAP_STATUS_UNFILLED = exports.GAP_STATUS_UNFILLED = _i18n.i18n.translate('xpack.securitySolution.gapsTable.gapStatus.unfilled', {
  defaultMessage: 'Unfilled'
});
const GAP_STATUS_PARTIALLY_FILLED = exports.GAP_STATUS_PARTIALLY_FILLED = _i18n.i18n.translate('xpack.securitySolution.gapsTable.gapStatus.partiallyFilled', {
  defaultMessage: 'Partially filled'
});
const GAP_STATUS_FILLED = exports.GAP_STATUS_FILLED = _i18n.i18n.translate('xpack.securitySolution.gapsTable.gapStatus.filled', {
  defaultMessage: 'Filled'
});
const GAPS_TABLE_MANUAL_FILL_TASKS_LABEL = exports.GAPS_TABLE_MANUAL_FILL_TASKS_LABEL = _i18n.i18n.translate('xpack.securitySolution.gapsTable.manualFillTasksLabel', {
  defaultMessage: 'Manual fill tasks'
});
const GAPS_TABLE_MANUAL_FILL_TASKS_LABEL_TOOLTIP = exports.GAPS_TABLE_MANUAL_FILL_TASKS_LABEL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.gapsTable.manualFillTasksLabelTooltip', {
  defaultMessage: 'Status of manual run filling the gap'
});
const GAPS_TABLE_IN_PROGRESS_LABEL = exports.GAPS_TABLE_IN_PROGRESS_LABEL = _i18n.i18n.translate('xpack.securitySolution.gapsTable.inProgressIntervalsLabel', {
  defaultMessage: 'In progress'
});
const GAPS_TABLE_EVENT_TIME_COVERED_LABEL = exports.GAPS_TABLE_EVENT_TIME_COVERED_LABEL = _i18n.i18n.translate('xpack.securitySolution.gapsTable.eventTimeCoveredLabel', {
  defaultMessage: 'Event time covered'
});
const GAPS_TABLE_EVENT_TIME_COVERED_LABEL_TOOLTIP = exports.GAPS_TABLE_EVENT_TIME_COVERED_LABEL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.gapsTable.eventTimeCoveredLabelTooltip', {
  defaultMessage: 'Progress of manual run filling the gap'
});
const GAPS_TABLE_GAP_RANGE_LABEL = exports.GAPS_TABLE_GAP_RANGE_LABEL = _i18n.i18n.translate('xpack.securitySolution.gapsTable.gapRangeLabel', {
  defaultMessage: 'Range'
});
const GAPS_TABLE_GAP_RANGE_LABEL_TOOLTIP = exports.GAPS_TABLE_GAP_RANGE_LABEL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.gapsTable.gapRangeLabelTooltip', {
  defaultMessage: 'Time range of gap'
});
const GAPS_TABLE_GAP_DURATION_LABEL = exports.GAPS_TABLE_GAP_DURATION_LABEL = _i18n.i18n.translate('xpack.securitySolution.gapsTable.gapDurationTooltip', {
  defaultMessage: 'Total gap duration'
});
const GAPS_TABLE_GAP_DURATION_LABEL_TOOLTIP = exports.GAPS_TABLE_GAP_DURATION_LABEL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.gapsTable.gapDurationLabelTooltip', {
  defaultMessage: 'How long gap lasted'
});
const GAPS_TABLE_FILL_GAP_BUTTON_LABEL = exports.GAPS_TABLE_FILL_GAP_BUTTON_LABEL = _i18n.i18n.translate('xpack.securitySolution.gapsTable.fillGapButtonLabel', {
  defaultMessage: 'Fill gap'
});
const GAPS_TABLE_FILL_REMAINING_GAP_BUTTON_LABEL = exports.GAPS_TABLE_FILL_REMAINING_GAP_BUTTON_LABEL = _i18n.i18n.translate('xpack.securitySolution.gapsTable.fillRemainingGapButtonLabel', {
  defaultMessage: 'Fill remaining gap'
});
const GAP_FILL_REQUEST_SUCCESS_MESSAGE = exports.GAP_FILL_REQUEST_SUCCESS_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.gapsTable.gapFillRequestSuccessMessage', {
  defaultMessage: 'Manual run requested'
});
const GAP_FILL_REQUEST_SUCCESS_MESSAGE_TOOLTIP = exports.GAP_FILL_REQUEST_SUCCESS_MESSAGE_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.gapsTable.gapFillRequestSuccessMessageTooltip', {
  defaultMessage: 'Check status in rule execution logs. Actions for this execution will be run.'
});
const GAP_FILL_REQUEST_ERROR_MESSAGE = exports.GAP_FILL_REQUEST_ERROR_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.gapsTable.gapFillRequestErrorMessage', {
  defaultMessage: 'Failed to request manual run'
});
const GAP_STATUS_FILTER_TITLE = exports.GAP_STATUS_FILTER_TITLE = _i18n.i18n.translate('xpack.securitySolution.gapsTable.gapStatusFilterTitle', {
  defaultMessage: 'Status'
});
const GAPS_TABLE_EVENT_TIME_LABEL = exports.GAPS_TABLE_EVENT_TIME_LABEL = _i18n.i18n.translate('xpack.securitySolution.gapsTable.eventTimeLabel', {
  defaultMessage: 'Detected at'
});
const GAPS_TABLE_EVENT_TIME_LABEL_TOOLTIP = exports.GAPS_TABLE_EVENT_TIME_LABEL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.gapsTable.eventTimeLabelTooltip', {
  defaultMessage: 'Date and time gap was discovered'
});
const GAP_FILL_DISABLED_MESSAGE = exports.GAP_FILL_DISABLED_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.gapsTable.gapFillDisabledMessage', {
  defaultMessage: 'Rule should be enabled to fill gaps'
});
const GAPS_TABLE_TOTAL_GAPS_LABEL = (totalItems, maxItems) => _i18n.i18n.translate('xpack.securitySolution.gapsTable.totalGapsLabel', {
  values: {
    totalItems,
    maxItems
  },
  defaultMessage: `More than {totalItems} gaps match filters provided. Showing first {maxItems}. Constrain filters further to view additional gaps.`
});
exports.GAPS_TABLE_TOTAL_GAPS_LABEL = GAPS_TABLE_TOTAL_GAPS_LABEL;
const GAPS_FILL_ALL_GAPS_ERROR_DISABLED_RULE_MESSAGE = exports.GAPS_FILL_ALL_GAPS_ERROR_DISABLED_RULE_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.gaps.dryRunBulkFillRuleGaps.failedModalDisabledRuleErrorLabel', {
  defaultMessage: 'Enable the rule to schedule gap fills.'
});
const GAPS_FILL_ALL_GAPS_UNKNOWN_ERROR_MESSAGE = message => _i18n.i18n.translate('xpack.securitySolution.gaps.dryRunBulkFillRuleGaps.failedModalUnknownErrorLabel', {
  values: {
    message
  },
  defaultMessage: 'Cannot fill gaps for 1 rule ({message})'
});
exports.GAPS_FILL_ALL_GAPS_UNKNOWN_ERROR_MESSAGE = GAPS_FILL_ALL_GAPS_UNKNOWN_ERROR_MESSAGE;
const GAPS_FILL_ALL_GAPS_BUTTON_LABEL = exports.GAPS_FILL_ALL_GAPS_BUTTON_LABEL = _i18n.i18n.translate('xpack.securitySolution.gaps.fillAllGapsButtonLabel', {
  defaultMessage: 'Fill gaps'
});
const GAPS_FILL_ALL_GAPS_DRY_RUN_FAILED_MODAL_CLOSE_BUTTON_LABEL = exports.GAPS_FILL_ALL_GAPS_DRY_RUN_FAILED_MODAL_CLOSE_BUTTON_LABEL = _i18n.i18n.translate('xpack.securitySolution.gaps.dryRunBulkFillRuleGaps.failedModalCloseButtonLabel', {
  defaultMessage: 'Close'
});
const GAPS_FILL_ALL_GAPS_DRY_RUN_MODAL_HEADING = exports.GAPS_FILL_ALL_GAPS_DRY_RUN_MODAL_HEADING = _i18n.i18n.translate('xpack.securitySolution.gaps.dryRunBulkFillRuleGaps.failedModalHeading', {
  defaultMessage: 'Unable to schedule gap fills for a disabled rule'
});
const GAPS_FILL_ALL_GAPS_WARNING_TOAST_TITLE = exports.GAPS_FILL_ALL_GAPS_WARNING_TOAST_TITLE = _i18n.i18n.translate('xpack.securitySolution.gaps.fillRuleGapsLongRunWarningToastTitle', {
  defaultMessage: 'Scheduling gap fills'
});
const GAPS_FILL_ALL_GAPS_WARNING_TOAST_DESCRIPTION = exports.GAPS_FILL_ALL_GAPS_WARNING_TOAST_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.gaps.fillRuleGapsLongRunWarningToastMessage', {
  defaultMessage: 'Scheduling gap fills for 1 rule.'
});
const GAPS_FILL_ALL_GAPS_WARNING_TOAST_NOTIFY = exports.GAPS_FILL_ALL_GAPS_WARNING_TOAST_NOTIFY = _i18n.i18n.translate('xpack.securitySolution.gaps.fillRuleGapsLongRunWarningToastNotifyLabel', {
  defaultMessage: `Notify me when done`
});