"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleBackfillsInfo = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_find_backfills_for_rules = require("../../api/hooks/use_find_backfills_for_rules");
var _stop_backfill = require("./stop_backfill");
var _backfill_status = require("./backfill_status");
var _formatted_date = require("../../../../common/components/formatted_date");
var i18n = _interopRequireWildcard(require("../../translations"));
var _privileges = require("../../../../common/utils/privileges");
var _user_info = require("../../../../detections/components/user_info");
var _utils = require("./utils");
var _header_section = require("../../../../common/components/header_section");
var _table_header_tooltip_cell = require("../../../rule_management_ui/components/rules_table/table_header_tooltip_cell");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE_SIZE = 10;
const getBackfillsTableColumns = hasCRUDPermissions => {
  const stopAction = {
    name: i18n.BACKFILLS_TABLE_COLUMN_ACTION,
    render: item => /*#__PURE__*/_react.default.createElement(_stop_backfill.StopBackfill, {
      backfill: item
    }),
    width: '10%'
  };
  const columns = [{
    field: 'status',
    name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
      title: i18n.BACKFILLS_TABLE_COLUMN_STATUS,
      tooltipContent: i18n.BACKFILLS_TABLE_COLUMN_STATUS_TOOLTIP
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_backfill_status.BackfillStatusInfo, {
      status: value
    }),
    width: '10%'
  }, {
    field: 'created_at',
    name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
      title: i18n.BACKFILLS_TABLE_COLUMN_CREATED_AT,
      tooltipContent: i18n.BACKFILLS_TABLE_COLUMN_CREATED_AT_TOOLTIP
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      value: value,
      fieldName: 'created_at'
    }),
    width: '20%'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
      title: i18n.BACKFILLS_TABLE_COLUMN_SOURCE_TIME_RANGE,
      tooltipContent: i18n.BACKFILLS_TABLE_COLUMN_SOURCE_TIME_RANGE_TOOLTIP
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      value: value.start,
      fieldName: 'start'
    }), ' - ', /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      value: value.end,
      fieldName: 'end'
    })),
    width: '30%'
  }, {
    field: 'error',
    align: 'right',
    name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
      title: i18n.BACKFILLS_TABLE_COLUMN_ERROR,
      tooltipContent: i18n.BACKFILLS_TABLE_COLUMN_ERROR_TOOLTIP
    }),
    'data-test-subj': 'rule-backfills-column-error'
  }, {
    field: 'pending',
    align: 'right',
    name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
      title: i18n.BACKFILLS_TABLE_COLUMN_PENDING,
      tooltipContent: i18n.BACKFILLS_TABLE_COLUMN_PENDING_TOOLTIP
    }),
    'data-test-subj': 'rule-backfills-column-pending'
  }, {
    field: 'running',
    align: 'right',
    name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
      title: i18n.BACKFILLS_TABLE_COLUMN_RUNNING,
      tooltipContent: i18n.BACKFILLS_TABLE_COLUMN_RUNNING_TOOLTIP
    }),
    'data-test-subj': 'rule-backfills-column-running'
  }, {
    field: 'complete',
    align: 'right',
    name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
      title: i18n.BACKFILLS_TABLE_COLUMN_COMPLETED,
      tooltipContent: i18n.BACKFILLS_TABLE_COLUMN_COMPLETED_TOOLTIP
    }),
    'data-test-subj': 'rule-backfills-column-completed'
  }, {
    field: 'total',
    align: 'right',
    name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
      title: i18n.BACKFILLS_TABLE_COLUMN_TOTAL,
      tooltipContent: i18n.BACKFILLS_TABLE_COLUMN_TOTAL_TOOLTIP
    }),
    'data-test-subj': 'rule-backfills-column-total'
  }];
  if (hasCRUDPermissions) {
    columns.push(stopAction);
  }
  return columns;
};
const RuleBackfillsInfo = exports.RuleBackfillsInfo = /*#__PURE__*/_react.default.memo(({
  ruleId
}) => {
  var _data$data, _data$total;
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(DEFAULT_PAGE_SIZE);
  const [{
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const hasCRUDPermissions = (0, _privileges.hasUserCRUDPermission)(canUserCRUD);
  const {
    timelines
  } = (0, _kibana.useKibana)().services;
  const {
    data,
    isLoading,
    isError,
    refetch,
    dataUpdatedAt
  } = (0, _use_find_backfills_for_rules.useFindBackfillsForRules)({
    ruleIds: [ruleId],
    page: pageIndex + 1,
    perPage: pageSize
  });
  const backfills = (0, _utils.getBackfillRowsFromResponse)((_data$data = data === null || data === void 0 ? void 0 : data.data) !== null && _data$data !== void 0 ? _data$data : []);
  const columns = getBackfillsTableColumns(hasCRUDPermissions);
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount: (_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0
  };
  const handleTableChange = ({
    page,
    sort
  }) => {
    if (page) {
      setPageIndex(page.index);
      setPageSize(page.size);
    }
  };
  const handleRefresh = () => {
    refetch();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    gutterSize: "s",
    "data-test-subj": "rule-backfills-info"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: i18n.BACKFILL_TABLE_TITLE,
    subtitle: i18n.BACKFILL_TABLE_SUBTITLE
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "refresh",
    fill: true,
    onClick: handleRefresh
  }, i18n.BACKFILL_TABLE_REFRESH))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, timelines.getLastUpdated({
    showUpdating: isLoading,
    updatedAt: dataUpdatedAt
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "rule-backfills-table",
    items: backfills,
    columns: columns,
    pagination: pagination,
    error: isError ? 'error' : undefined,
    loading: isLoading,
    onChange: handleTableChange
  }));
});
RuleBackfillsInfo.displayName = 'RuleBackfillsInfo';