"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetGapsSummaryByRuleIds = void 0;
var _reactQuery = require("@tanstack/react-query");
var _api = require("../api");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GET_GAPS_SUMMARY_BY_RULE_IDS = ['GET_GAPS_SUMMARY_BY_RULE_IDS'];
const useGetGapsSummaryByRuleIds = ({
  gapRange,
  ruleIds
}, options) => {
  return (0, _reactQuery.useQuery)([...GET_GAPS_SUMMARY_BY_RULE_IDS, ...ruleIds, gapRange], async ({
    signal
  }) => {
    const {
      start,
      end
    } = (0, _utils.getGapRange)(gapRange);
    const response = await (0, _api.getGapsSummaryByRuleIds)({
      signal,
      start,
      end,
      ruleIds
    });
    return response;
  }, {
    retry: 0,
    keepPreviousData: true,
    ...options
  });
};
exports.useGetGapsSummaryByRuleIds = useGetGapsSummaryByRuleIds;