"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFlattenedArrayFieldNames = getFlattenedArrayFieldNames;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a list of flattened field names for a given array field of a form.
 * Flattened field name is a string that represents the path to an item in an array field.
 * For example, a field "myArrayField" can be represented as "myArrayField[0]", "myArrayField[1]", etc.
 *
 * Flattened field names are useful:
 * - when you need to subscribe to changes in an array field using `useFormData` "watch" option
 * - when you need to retrieve form data before serializer function is applied
 *
 * @param {Object} form - Form object.
 * @param {string} arrayFieldName - Path to the array field.
 * @returns {string[]} - Flattened array field names.
 */
function getFlattenedArrayFieldNames(form, arrayFieldName) {
  var _form$getFields, _internalField$value;
  const internalField = (_form$getFields = form.getFields()[`${arrayFieldName}__array__`]) !== null && _form$getFields !== void 0 ? _form$getFields : {};
  const internalFieldValue = (_internalField$value = internalField === null || internalField === void 0 ? void 0 : internalField.value) !== null && _internalField$value !== void 0 ? _internalField$value : [];
  return internalFieldValue.map(item => item.path);
}