"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUnknownThreatMatchMappingFieldNames = getUnknownThreatMatchMappingFieldNames;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getUnknownThreatMatchMappingFieldNames({
  entries,
  indexPatterns,
  threatIndexPatterns
}) {
  const knownIndexPatternsFields = new Set(indexPatterns.fields.map(({
    name
  }) => name));
  const knownThreatMatchIndexPatternsFields = new Set(threatIndexPatterns.fields.map(({
    name
  }) => name));
  const unknownSourceIndicesFields = [];
  const unknownThreatMatchIndicesFields = [];
  for (const {
    entries: subEntries
  } of entries) {
    for (const subEntry of subEntries) {
      if (subEntry.field && !knownIndexPatternsFields.has(subEntry.field)) {
        unknownSourceIndicesFields.push(subEntry.field);
      }
      if (subEntry.value && !knownThreatMatchIndexPatternsFields.has(subEntry.value)) {
        unknownThreatMatchIndicesFields.push(subEntry.value);
      }
    }
  }
  return {
    unknownSourceIndicesFields,
    unknownThreatMatchIndicesFields
  };
}